/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.helpers;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.DOMUtils;
import org.jboss.ws.common.DOMWriter;
import org.jboss.ws.common.IOUtils;
import org.jboss.ws.common.JavaUtils;
import org.jboss.ws.core.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.core.soap.Style;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.umdm.WrappedParameter;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.tools.Configuration;
import org.jboss.ws.tools.JavaToWSDL;
import org.jboss.ws.tools.JavaWriter;
import org.jboss.ws.tools.NamespacePackageMapping;
import org.jboss.ws.tools.WSDLToJava;
import org.jboss.ws.tools.WebservicesXMLCreatorImpl;
import org.jboss.ws.tools.XSDTypeToJava;
import org.jboss.ws.tools.client.ServiceCreator;
import org.jboss.ws.tools.helpers.SecurityActions;
import org.jboss.ws.tools.mapping.MappingFileGenerator;
import org.jboss.ws.tools.wsdl.WSDLWriter;
import org.w3c.dom.Node;

public class ToolsHelper {
    private static final ResourceBundle bundle = BundleUtils.getBundle(ToolsHelper.class);
    private static Logger log = Logger.getLogger(ToolsHelper.class);

    public void handleJavaToWSDLGeneration(Configuration config, String outDir) throws IOException {
        Configuration.JavaToWSDLConfig j2wc = config.getJavaToWSDLConfig(false);
        JavaToWSDL jwsdl = new JavaToWSDL("http://schemas.xmlsoap.org/wsdl/");
        jwsdl.setServiceName(j2wc.serviceName);
        jwsdl.setTargetNamespace(j2wc.targetNamespace);
        jwsdl.setTypeNamespace(j2wc.typeNamespace);
        jwsdl.setOperationMap(j2wc.operations);
        if ("document".equals(j2wc.wsdlStyle)) {
            jwsdl.setStyle(Style.DOCUMENT);
        } else if ("rpc".equals(j2wc.wsdlStyle)) {
            jwsdl.setStyle(Style.RPC);
        } else {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNRECOGNIZED_STYLE", (Object[])new Object[]{j2wc.wsdlStyle}));
        }
        if ("wrapped".equals(j2wc.parameterStyle)) {
            jwsdl.setParameterStyle(SOAPBinding.ParameterStyle.WRAPPED);
        } else if ("bare".equals(j2wc.parameterStyle)) {
            jwsdl.setParameterStyle(SOAPBinding.ParameterStyle.BARE);
        } else {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNRECOGNIZED_PARAMETER_STYLE", (Object[])new Object[]{j2wc.parameterStyle}));
        }
        Class endpointClass = this.loadClass(j2wc.endpointName);
        if (endpointClass == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ENDPOINT_CANNOT_BE_LOADED", (Object[])new Object[]{j2wc.endpointName}));
        }
        Configuration.GlobalConfig gcfg = config.getGlobalConfig(false);
        if (gcfg != null && gcfg.packageNamespaceMap != null) {
            jwsdl.setPackageNamespaceMap(gcfg.packageNamespaceMap);
        }
        WSDLDefinitions wsdl = jwsdl.generate(endpointClass);
        this.createDir(outDir + "/wsdl");
        String wsdlPath = outDir + "/wsdl/" + j2wc.serviceName + ".wsdl";
        Writer fw = IOUtils.getCharsetFileWriter((File)new File(wsdlPath), (String)"UTF-8");
        new WSDLWriter(wsdl).write(fw, "UTF-8");
        fw.close();
        if (j2wc.mappingFileNeeded) {
            UnifiedMetaData unifiedMetaData = jwsdl.getUnifiedMetaData();
            JavaWsdlMapping mapping = jwsdl.getJavaWsdlMapping();
            this.createWrapperTypes(j2wc, outDir, unifiedMetaData, mapping, endpointClass);
            Writer writer = IOUtils.getCharsetFileWriter((File)new File(outDir + "/" + j2wc.mappingFileName), (String)"UTF-8");
            writer.write("<?xml version='1.0' encoding='UTF-8'?>");
            writer.write(DOMWriter.printNode((Node)DOMUtils.parse((String)mapping.serialize()), (boolean)true));
            writer.close();
        }
        if (j2wc.wsxmlFileNeeded) {
            WebservicesXMLCreatorImpl wscr = new WebservicesXMLCreatorImpl();
            wscr.setTargetNamespace(j2wc.targetNamespace);
            wscr.setSeiName(j2wc.endpointName);
            wscr.setServiceName(j2wc.serviceName);
            WSDLService wsdlService = wsdl.getService(j2wc.serviceName);
            String portName = wsdlService.getEndpoints()[0].getName().getLocalPart();
            wscr.setPortName(portName);
            if (j2wc.servletLink != null) {
                wscr.setMappingFile("WEB-INF/" + j2wc.mappingFileName);
                wscr.setWsdlFile("WEB-INF/wsdl/" + j2wc.serviceName + ".wsdl");
                wscr.setServletLink(j2wc.servletLink);
            } else {
                wscr.setMappingFile("META-INF/" + j2wc.mappingFileName);
                wscr.setWsdlFile("META-INF/wsdl/" + j2wc.serviceName + ".wsdl");
                wscr.setEjbLink(j2wc.ejbLink);
            }
            wscr.setAppend(j2wc.wsxmlFileAppend);
            wscr.generateWSXMLDescriptor(new File(outDir + "/webservices.xml"));
        }
    }

    private void createWrapperTypes(Configuration.JavaToWSDLConfig j2wc, String outDir, UnifiedMetaData wsMetaData, JavaWsdlMapping mapping, Class endpointClass) throws IOException {
        ServiceMetaData service;
        Map<QName, JavaXmlTypeMapping> index = this.indexMappingTypes(mapping);
        EndpointMetaData epMetaData = null;
        Iterator<ServiceMetaData> i$ = wsMetaData.getServices().iterator();
        while (i$.hasNext() && (epMetaData = (service = i$.next()).getEndpointByServiceEndpointInterface(j2wc.endpointName)) == null) {
        }
        if (epMetaData == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"COULD_NOT_FIND_ENDPOINT_IN_METADATA", (Object[])new Object[]{j2wc.endpointName}));
        }
        String packageName = endpointClass.getPackage().getName();
        ClassLoader classLoader = wsMetaData.getClassLoader();
        for (OperationMetaData opMetaData : epMetaData.getOperations()) {
            if (!opMetaData.isDocumentWrapped()) continue;
            for (ParameterMetaData parameter : opMetaData.getParameters()) {
                String name = endpointClass.getSimpleName() + "_" + opMetaData.getQName().getLocalPart() + "_RequestStruct";
                this.createWrapperType(parameter, name, packageName, index, classLoader, outDir);
            }
            ParameterMetaData returnParameter = opMetaData.getReturnParameter();
            if (returnParameter == null) continue;
            String name = endpointClass.getSimpleName() + "_" + opMetaData.getQName().getLocalPart() + "_ResponseStruct";
            this.createWrapperType(returnParameter, name, packageName, index, classLoader, outDir);
        }
    }

    private void createWrapperType(ParameterMetaData parameter, String name, String packageName, Map<QName, JavaXmlTypeMapping> mappingIndex, ClassLoader classLoader, String outDir) throws IOException {
        List<WrappedParameter> wrappedParameters = parameter.getWrappedParameters();
        if (wrappedParameters == null) {
            return;
        }
        ArrayList<XSDTypeToJava.VAR> vars = new ArrayList<XSDTypeToJava.VAR>();
        for (WrappedParameter wrapped : wrappedParameters) {
            String typeName = JavaUtils.convertJVMNameToSourceName((String)wrapped.getType(), (ClassLoader)classLoader);
            vars.add(new XSDTypeToJava.VAR(wrapped.getVariable(), typeName, false));
        }
        JavaWriter writer = new JavaWriter();
        writer.createJavaFile(new File(outDir), name + ".java", packageName, vars, null, null, false, false, null);
        JavaXmlTypeMapping type = mappingIndex.get(parameter.getXmlType());
        if (type == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"MISSING_A_WRAPPER_TYPE", (Object[])new Object[]{parameter.getXmlType()}));
        }
        type.setJavaType(packageName + "." + name);
    }

    private Map<QName, JavaXmlTypeMapping> indexMappingTypes(JavaWsdlMapping mapping) {
        HashMap<QName, JavaXmlTypeMapping> index = new HashMap<QName, JavaXmlTypeMapping>();
        for (JavaXmlTypeMapping type : mapping.getJavaXmlTypeMappings()) {
            QName qname = type.getRootTypeQName();
            if (qname == null) continue;
            index.put(qname, type);
        }
        return index;
    }

    public void handleWSDLToJavaGeneration(Configuration config, String outDir) {
        Configuration.WSDLToJavaConfig w2jc = config.getWSDLToJavaConfig(false);
        Configuration.GlobalConfig glc = config.getGlobalConfig(false);
        WSDLToJava wsdlToJava = new WSDLToJava();
        wsdlToJava.setTypeMapping(new LiteralTypeMapping());
        wsdlToJava.setGenerateSerializableTypes(w2jc.serializableTypes);
        WSDLDefinitions wsdl = null;
        try {
            File wsdlFile;
            URL wsdlURL = null;
            try {
                wsdlURL = new URL(w2jc.wsdlLocation);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (wsdlURL == null && (wsdlFile = new File(w2jc.wsdlLocation)).exists()) {
                wsdlURL = wsdlFile.toURL();
            }
            if (wsdlURL == null) {
                ClassLoader ctxLoader = SecurityActions.getContextClassLoader();
                wsdlURL = SecurityActions.getResource(ctxLoader, w2jc.wsdlLocation);
            }
            if (wsdlURL == null) {
                throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_LOAD_WSDL", (Object[])new Object[]{w2jc.wsdlLocation}));
            }
            wsdl = wsdlToJava.convertWSDL2Java(wsdlURL);
            if (glc != null) {
                wsdlToJava.setNamespacePackageMap(glc.packageNamespaceMap);
            }
            wsdlToJava.setParameterStyle(w2jc.parameterStyle);
            wsdlToJava.generateSEI(wsdl, new File(outDir));
            this.generateServiceFile(this.getPackageName(wsdl, glc), wsdl, outDir);
            if (w2jc.mappingFileNeeded) {
                MappingFileGenerator mgf = new MappingFileGenerator(wsdl, new LiteralTypeMapping());
                if (glc != null && glc.packageNamespaceMap != null) {
                    mgf.setNamespacePackageMap(glc.packageNamespaceMap);
                }
                mgf.setServiceName(wsdl.getServices()[0].getName().getLocalPart());
                mgf.setParameterStyle(w2jc.parameterStyle);
                JavaWsdlMapping jwm = mgf.generate();
                Writer writer = IOUtils.getCharsetFileWriter((File)new File(outDir + "/" + w2jc.mappingFileName), (String)"UTF-8");
                writer.write("<?xml version='1.0' encoding='UTF-8'?>");
                writer.write(DOMWriter.printNode((Node)DOMUtils.parse((String)jwm.serialize()), (boolean)true));
                writer.close();
            }
            if (w2jc.wsxmlFileNeeded) {
                String seiName = "mypackage.MyServiceEndpointInterface";
                String serviceName = "MyServiceName";
                if (wsdl.getServices().length == 1) {
                    serviceName = wsdl.getServices()[0].getName().getLocalPart();
                }
                if (wsdl.getInterfaces().length == 1) {
                    String seiPackage = this.getPackageName(wsdl, glc);
                    seiName = seiPackage + "." + wsdlToJava.getServiceEndpointInterfaceName(wsdl.getInterfaces()[0]);
                }
                WebservicesXMLCreatorImpl wscr = new WebservicesXMLCreatorImpl();
                wscr.setTargetNamespace(wsdl.getTargetNamespace());
                wscr.setSeiName(seiName);
                wscr.setServiceName(serviceName);
                WSDLService wsdlService = wsdl.getService(serviceName);
                String portName = wsdlService.getEndpoints()[0].getName().getLocalPart();
                wscr.setPortName(portName);
                String wsdlShortName = wsdlURL.getPath();
                wsdlShortName = wsdlShortName.substring(wsdlShortName.lastIndexOf("/"));
                if (w2jc.servletLink != null) {
                    wscr.setMappingFile("WEB-INF/" + w2jc.mappingFileName);
                    wscr.setWsdlFile("WEB-INF/wsdl" + wsdlShortName);
                    wscr.setServletLink(w2jc.servletLink);
                } else {
                    wscr.setMappingFile("META-INF/" + w2jc.mappingFileName);
                    wscr.setWsdlFile("META-INF/wsdl" + wsdlShortName);
                    wscr.setEjbLink(w2jc.ejbLink);
                }
                wscr.generateWSXMLDescriptor(new File(outDir + "/webservices.xml"));
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException(ex);
        }
    }

    private Class loadClass(String cls) {
        Class<?> clazz = null;
        try {
            clazz = SecurityActions.loadClass(SecurityActions.getContextClassLoader(), cls);
        }
        catch (Exception e) {
            log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_LOAD_ENDPOINT", (Object[])new Object[]{e.getLocalizedMessage()}));
        }
        return clazz;
    }

    private void generateServiceFile(String packageName, WSDLDefinitions wsdl, String location) throws IOException {
        ServiceCreator sc = new ServiceCreator();
        sc.setPackageName(packageName);
        sc.setDirLocation(new File(location));
        sc.setWsdl(wsdl);
        sc.createServiceDescriptor();
    }

    private String getPackageName(WSDLDefinitions wsdl, Configuration.GlobalConfig glc) {
        String pkg;
        String targetNamespace = wsdl.getTargetNamespace();
        if (glc != null && glc.packageNamespaceMap != null && (pkg = glc.packageNamespaceMap.get(targetNamespace)) != null) {
            return pkg;
        }
        return NamespacePackageMapping.getJavaPackageName(targetNamespace);
    }

    private void createDir(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }
}

