/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.Request;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RspFilter;
import org.jgroups.util.Rsp;

public class UnicastRequest<T>
extends Request {
    protected final Rsp<T> result;
    protected final Address target;
    protected int num_received = 0;

    public UnicastRequest(Message msg, RequestCorrelator corr, Address target, RequestOptions options) {
        super(msg, corr, options);
        this.target = target;
        this.result = new Rsp(target);
    }

    public UnicastRequest(Message msg, Address target, RequestOptions options) {
        super(msg, null, options);
        this.target = target;
        this.result = new Rsp(target);
    }

    @Override
    protected void sendRequest() throws Exception {
        try {
            if (log.isTraceEnabled()) {
                log.trace(new StringBuilder("sending request (id=").append(this.req_id).append(')'));
            }
            this.corr.sendUnicastRequest(this.req_id, this.target, this.request_msg, this.options.getMode() == ResponseMode.GET_NONE ? null : this);
        }
        catch (Exception ex) {
            if (this.corr != null) {
                this.corr.done(this.req_id);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveResponse(Object response_value, Address sender, boolean is_exception) {
        RspFilter rsp_filter = this.options.getRspFilter();
        this.lock.lock();
        try {
            if (this.done) {
                return;
            }
            if (!this.result.wasReceived()) {
                ++this.num_received;
                if (rsp_filter == null || rsp_filter.isAcceptable(response_value, sender)) {
                    if (is_exception && response_value instanceof Throwable) {
                        this.result.setException((Throwable)response_value);
                    } else {
                        this.result.setValue(response_value);
                    }
                    this.result.setReceived(true);
                    if (log.isTraceEnabled()) {
                        StringBuilder sb = new StringBuilder("received response for request ");
                        sb.append(this.req_id).append(", sender=").append(sender);
                        if (is_exception && response_value instanceof Throwable) {
                            sb.append(", exception=");
                        } else {
                            sb.append(", val=");
                        }
                        sb.append(response_value);
                        log.trace(sb.toString());
                    }
                }
            }
            boolean bl = this.done = this.responsesComplete() || rsp_filter != null && !rsp_filter.needMoreResponses();
            if (this.done && this.corr != null) {
                this.corr.done(this.req_id);
            }
        }
        finally {
            this.completed.signalAll();
            this.lock.unlock();
        }
        this.checkCompletion(this);
    }

    public boolean responseReceived() {
        return this.num_received >= 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspect(Address suspected_member) {
        if (suspected_member == null || !suspected_member.equals(this.target)) {
            return;
        }
        this.lock.lock();
        try {
            if (this.done) {
                return;
            }
            if (this.result != null && !this.result.wasReceived()) {
                this.result.setSuspected(true);
            }
            this.done = true;
            if (this.corr != null) {
                this.corr.done(this.req_id);
            }
            this.completed.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        this.checkCompletion(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewChange(View new_view) {
        List<Address> mbrs;
        List<Address> list = mbrs = new_view != null ? new_view.getMembers() : null;
        if (mbrs == null) {
            return;
        }
        this.lock.lock();
        try {
            if (!mbrs.contains(this.target)) {
                this.result.setReceived(false);
                this.done = true;
                if (this.corr != null) {
                    this.corr.done(this.req_id);
                }
                this.completed.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
        this.checkCompletion(this);
    }

    public Rsp<T> getResult() {
        return this.result;
    }

    public T getValue() throws ExecutionException {
        if (!this.result.hasException()) {
            return this.result.getValue();
        }
        throw new ExecutionException(this.result.getException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.lock.lock();
        try {
            this.waitForResults(0L);
            T t = this.getValue();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean ok;
        this.lock.lock();
        try {
            ok = this.waitForResults(unit.toMillis(timeout));
        }
        finally {
            this.lock.unlock();
        }
        if (!ok) {
            throw new TimeoutException();
        }
        return this.getValue();
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder(128);
        ret.append(super.toString());
        ret.append(", target=" + this.target);
        return ret.toString();
    }

    @Override
    protected boolean responsesComplete() {
        return this.done || this.options.getMode() == ResponseMode.GET_NONE || this.result.wasReceived() || this.result.wasSuspected() || this.num_received >= 1;
    }
}

