/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.listener;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;
import org.jacorb.orb.listener.SSLSessionEvent;
import org.jacorb.orb.listener.SSLSessionListener;
import org.slf4j.Logger;

public class SSLHandshakeListener
implements HandshakeCompletedListener {
    private final Logger logger;
    private final SSLSessionListener sslListener;

    public SSLHandshakeListener(Logger logger, SSLSessionListener sSLSessionListener) {
        this.logger = logger;
        this.sslListener = sSLSessionListener;
    }

    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
        X509Certificate[] x509CertificateArray = null;
        String string = null;
        try {
            x509CertificateArray = handshakeCompletedEvent.getPeerCertificateChain();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("handshakeCompleted - SSLPeerUnverifiedException");
            }
            x509CertificateArray = new X509Certificate[]{};
        }
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Unable to resolve local IP address - using default");
            }
            string = "127.0.0.1";
        }
        this.sslListener.sessionCreated(new SSLSessionEvent(handshakeCompletedEvent.getSource(), handshakeCompletedEvent.getSocket().getInetAddress().getHostAddress(), handshakeCompletedEvent.getSocket().getPort(), x509CertificateArray, handshakeCompletedEvent.getSocket().getLocalPort(), string, null));
    }
}

