/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process;

import java.io.Serializable;
import java.net.InetAddress;
import org.jboss.as.process.ProcessLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class ProcessLogger_$logger
extends DelegatingBasicLogger
implements Serializable,
ProcessLogger,
BasicLogger {
    private static final long serialVersionUID = 1L;
    private static final String projectCode = "JBAS";
    private static final String FQCN = ProcessLogger_$logger.class.getName();
    private static final String receivedUnknownCredentials = "Received connection with unknown credentials from %s";
    private static final String failedToSendReconnect = "Failed to send reconnect message to process '%s' input stream";
    private static final String failedToWriteMessage = "Failed to write %s message to connection: %s";
    private static final String failedToSendAuthKey = "Failed to send authentication key to process '%s': %s";
    private static final String failedToStartProcess = "Failed to start process '%s'";
    private static final String shuttingDown = "Shutting down process controller";
    private static final String attemptToRemoveNonExistentProcess = "Attempted to remove non-existent process '%s'";
    private static final String startingProcess = "Starting process '%s'";
    private static final String attemptToReconnectNonExistentProcess = "Attempted to reconnect non-existent process '%s'";
    private static final String attemptToStopNonExistentProcess = "Attempted to stop non-existent process '%s'";
    private static final String failedToSendDataBytes = "Failed to send data bytes to process '%s' input stream";
    private static final String streamProcessingFailed = "Stream processing failed for process '%s': %s";
    private static final String attemptToStartNonExistentProcess = "Attempted to start non-existent process '%s'";
    private static final String processFinished = "Process '%s' finished with an exit status of %d";
    private static final String receivedUnknownMessageCode = "Received unknown message with code 0x%02x";
    private static final String receivedUnknownGreetingCode = "Received unrecognized greeting code 0x%02x from %s";
    private static final String duplicateProcessName = "Attempted to register duplicate named process '%s'";
    private static final String stoppingProcess = "Stopping process '%s'";
    private static final String shutdownComplete = "All processes finished; exiting";
    private static final String receivedInvalidVersion = "Received connection with invalid version from %s";
    private static final String waitingToRestart = "Waiting %d seconds until trying to restart process %s.";

    public ProcessLogger_$logger(Logger log) {
        super(log);
    }

    @Override
    public final void receivedUnknownCredentials(InetAddress address) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "JBAS012013: " + this.receivedUnknownCredentials$str(), (Object)address);
    }

    protected String receivedUnknownCredentials$str() {
        return receivedUnknownCredentials;
    }

    @Override
    public final void failedToSendReconnect(Throwable cause, String processName) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, "JBAS012007: " + this.failedToSendReconnect$str(), (Object)processName);
    }

    protected String failedToSendReconnect$str() {
        return failedToSendReconnect;
    }

    @Override
    public final void failedToWriteMessage(String messageType, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, "JBAS012009: " + this.failedToWriteMessage$str(), (Object)messageType, (Object)t);
    }

    protected String failedToWriteMessage$str() {
        return failedToWriteMessage;
    }

    @Override
    public final void failedToSendAuthKey(String processName, Throwable error) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "JBAS012005: " + this.failedToSendAuthKey$str(), (Object)processName, (Object)error);
    }

    protected String failedToSendAuthKey$str() {
        return failedToSendAuthKey;
    }

    @Override
    public final void failedToStartProcess(String processName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, "JBAS012008: " + this.failedToStartProcess$str(), (Object)processName);
    }

    protected String failedToStartProcess$str() {
        return failedToStartProcess;
    }

    @Override
    public final void shuttingDown() {
        this.log.logf(FQCN, Logger.Level.INFO, null, "JBAS012016: " + this.shuttingDown$str(), new Object[0]);
    }

    protected String shuttingDown$str() {
        return shuttingDown;
    }

    @Override
    public final void attemptToRemoveNonExistentProcess(String processName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "JBAS012001: " + this.attemptToRemoveNonExistentProcess$str(), (Object)processName);
    }

    protected String attemptToRemoveNonExistentProcess$str() {
        return attemptToRemoveNonExistentProcess;
    }

    @Override
    public final void startingProcess(String processName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "JBAS012017: " + this.startingProcess$str(), (Object)processName);
    }

    protected String startingProcess$str() {
        return startingProcess;
    }

    @Override
    public final void attemptToReconnectNonExistentProcess(String processName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "JBAS012000: " + this.attemptToReconnectNonExistentProcess$str(), (Object)processName);
    }

    protected String attemptToReconnectNonExistentProcess$str() {
        return attemptToReconnectNonExistentProcess;
    }

    @Override
    public final void attemptToStopNonExistentProcess(String processName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "JBAS012003: " + this.attemptToStopNonExistentProcess$str(), (Object)processName);
    }

    protected String attemptToStopNonExistentProcess$str() {
        return attemptToStopNonExistentProcess;
    }

    @Override
    public final void failedToSendDataBytes(Throwable cause, String processName) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, "JBAS012006: " + this.failedToSendDataBytes$str(), (Object)processName);
    }

    protected String failedToSendDataBytes$str() {
        return failedToSendDataBytes;
    }

    @Override
    public final void streamProcessingFailed(String processName, Throwable error) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, "JBAS012019: " + this.streamProcessingFailed$str(), (Object)processName, (Object)error);
    }

    protected String streamProcessingFailed$str() {
        return streamProcessingFailed;
    }

    @Override
    public final void attemptToStartNonExistentProcess(String processName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "JBAS012002: " + this.attemptToStartNonExistentProcess$str(), (Object)processName);
    }

    protected String attemptToStartNonExistentProcess$str() {
        return attemptToStartNonExistentProcess;
    }

    @Override
    public final void processFinished(String processName, int exitCode) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "JBAS012010: " + this.processFinished$str(), (Object)processName, (Object)exitCode);
    }

    protected String processFinished$str() {
        return processFinished;
    }

    @Override
    public final void receivedUnknownMessageCode(int code) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "JBAS120014: " + this.receivedUnknownMessageCode$str(), (Object)code);
    }

    protected String receivedUnknownMessageCode$str() {
        return receivedUnknownMessageCode;
    }

    @Override
    public final void receivedUnknownGreetingCode(int code, InetAddress address) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "JBAS012012: " + this.receivedUnknownGreetingCode$str(), (Object)code, (Object)address);
    }

    protected String receivedUnknownGreetingCode$str() {
        return receivedUnknownGreetingCode;
    }

    @Override
    public final void duplicateProcessName(String processName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "JBAS012004: " + this.duplicateProcessName$str(), (Object)processName);
    }

    protected String duplicateProcessName$str() {
        return duplicateProcessName;
    }

    @Override
    public final void stoppingProcess(String processName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "JBAS012018: " + this.stoppingProcess$str(), (Object)processName);
    }

    protected String stoppingProcess$str() {
        return stoppingProcess;
    }

    @Override
    public final void shutdownComplete() {
        this.log.logf(FQCN, Logger.Level.INFO, null, "JBAS012015: " + this.shutdownComplete$str(), new Object[0]);
    }

    protected String shutdownComplete$str() {
        return shutdownComplete;
    }

    @Override
    public final void receivedInvalidVersion(InetAddress address) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "JBAS012011: " + this.receivedInvalidVersion$str(), (Object)address);
    }

    protected String receivedInvalidVersion$str() {
        return receivedInvalidVersion;
    }

    @Override
    public final void waitingToRestart(int seconds, String processName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "JBAS012020: " + this.waitingToRestart$str(), (Object)seconds, (Object)processName);
    }

    protected String waitingToRestart$str() {
        return waitingToRestart;
    }
}

