/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jmx.JmxMessages;
import org.jboss.as.jmx.model.Constants;

class ObjectNameAddressUtil {
    private static final EscapedCharacter[] ESCAPED_KEY_CHARACTERS;
    private static final EscapedCharacter[] ECAPED_VALUE_CHARACTERS;

    ObjectNameAddressUtil() {
    }

    static ObjectName createObjectName(PathAddress pathAddress) {
        if (pathAddress.size() == 0) {
            return Constants.ROOT_MODEL_NAME;
        }
        StringBuilder sb = new StringBuilder("jboss.model");
        sb.append(":");
        boolean first = true;
        for (PathElement element : pathAddress) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            ObjectNameAddressUtil.appendEscapedCharacter(ESCAPED_KEY_CHARACTERS, sb, element.getKey());
            sb.append("=");
            ObjectNameAddressUtil.appendEscapedCharacter(ECAPED_VALUE_CHARACTERS, sb, element.getValue());
        }
        try {
            return ObjectName.getInstance(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            throw JmxMessages.MESSAGES.cannotCreateObjectName(e, pathAddress);
        }
    }

    static PathAddress resolvePathAddress(Resource rootResource, ObjectName name) {
        if (!name.getDomain().equals("jboss.model")) {
            return null;
        }
        if (name.equals(Constants.ROOT_MODEL_NAME)) {
            return PathAddress.EMPTY_ADDRESS;
        }
        Hashtable<String, String> properties = name.getKeyPropertyList();
        return ObjectNameAddressUtil.searchPathAddress(PathAddress.EMPTY_ADDRESS, rootResource, properties);
    }

    private static PathAddress searchPathAddress(PathAddress address, Resource resource, Map<String, String> properties) {
        if (properties.size() == 0) {
            return address;
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            PathElement childElement = PathElement.pathElement((String)ObjectNameAddressUtil.replaceEscapedCharacters(entry.getKey()), (String)ObjectNameAddressUtil.replaceEscapedCharacters(entry.getValue()));
            Resource child = resource.getChild(childElement);
            if (child == null) continue;
            HashMap<String, String> childProps = new HashMap<String, String>(properties);
            childProps.remove(entry.getKey());
            PathAddress foundAddr = ObjectNameAddressUtil.searchPathAddress(address.append(new PathElement[]{childElement}), child, childProps);
            if (foundAddr == null) continue;
            return foundAddr;
        }
        return null;
    }

    static boolean isReservedDomain(ObjectName name) {
        return name.getDomain().equals("jboss.model");
    }

    private static void appendEscapedCharacter(EscapedCharacter[] escapedCharacters, StringBuilder sb, String value) {
        for (EscapedCharacter escapedCharacter : escapedCharacters) {
            value = value.replace(escapedCharacter.getChar().toString(), escapedCharacter.getEscaped());
        }
        sb.append(value);
    }

    private static String replaceEscapedCharacters(String escaped) {
        if (escaped.contains("%x")) {
            for (EscapedCharacter escapedCharacter : ESCAPED_KEY_CHARACTERS) {
                escaped = escaped.replace(escapedCharacter.getEscaped(), escapedCharacter.getChar());
            }
        }
        return escaped;
    }

    static {
        ArrayList<EscapedCharacter> keys = new ArrayList<EscapedCharacter>();
        ArrayList<EscapedCharacter> values = new ArrayList<EscapedCharacter>();
        keys.add(new EscapedCharacter(Character.valueOf('*')));
        keys.add(new EscapedCharacter(Character.valueOf('?')));
        keys.add(new EscapedCharacter(Character.valueOf('+')));
        keys.add(new EscapedCharacter(Character.valueOf(':')));
        keys.add(new EscapedCharacter(Character.valueOf('=')));
        keys.add(new EscapedCharacter(Character.valueOf(',')));
        values.add(new EscapedCharacter(Character.valueOf(':')));
        values.add(new EscapedCharacter(Character.valueOf('=')));
        values.add(new EscapedCharacter(Character.valueOf(',')));
        ESCAPED_KEY_CHARACTERS = keys.toArray(new EscapedCharacter[keys.size()]);
        ECAPED_VALUE_CHARACTERS = keys.toArray(new EscapedCharacter[values.size()]);
    }

    private static class EscapedCharacter {
        private final String ch;
        private final String hexPart;
        private final String escaped;

        EscapedCharacter(Character ch) {
            this.ch = String.valueOf(ch);
            this.hexPart = Integer.toHexString(ch.charValue());
            this.escaped = "%x" + this.hexPart;
        }

        String getChar() {
            return this.ch;
        }

        String getEscaped() {
            return this.escaped;
        }
    }
}

