/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.paging.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.paging.Page;
import org.hornetq.core.paging.PagedMessage;
import org.hornetq.core.paging.cursor.LivePageCache;
import org.hornetq.core.paging.impl.PagedMessageImpl;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.server.LargeServerMessage;

public class PageImpl
implements Page,
Comparable<Page> {
    private static final Logger log = Logger.getLogger(PageImpl.class);
    private static final boolean isTrace = log.isTraceEnabled();
    private static final boolean isDebug = log.isDebugEnabled();
    public static final int SIZE_RECORD = 6;
    private static final byte START_BYTE = 123;
    private static final byte END_BYTE = 125;
    private final int pageId;
    private boolean suspiciousRecords = false;
    private final AtomicInteger numberOfMessages = new AtomicInteger(0);
    private final SequentialFile file;
    private final SequentialFileFactory fileFactory;
    private volatile LivePageCache pageCache;
    private final AtomicInteger size = new AtomicInteger(0);
    private final StorageManager storageManager;
    private final SimpleString storeName;

    public PageImpl(SimpleString storeName, StorageManager storageManager, SequentialFileFactory factory, SequentialFile file, int pageId) throws Exception {
        this.pageId = pageId;
        this.file = file;
        this.fileFactory = factory;
        this.storageManager = storageManager;
        this.storeName = storeName;
    }

    @Override
    public int getPageId() {
        return this.pageId;
    }

    @Override
    public void setLiveCache(LivePageCache pageCache) {
        this.pageCache = pageCache;
    }

    @Override
    public List<PagedMessage> read(StorageManager storage) throws Exception {
        if (isDebug) {
            log.debug("reading page " + this.pageId + " on address = " + this.storeName);
        }
        ArrayList<PagedMessage> messages = new ArrayList<PagedMessage>();
        this.size.set((int)this.file.size());
        ByteBuffer buffer2 = ByteBuffer.allocateDirect(this.size.get());
        this.file.position(0L);
        this.file.read(buffer2);
        buffer2.rewind();
        HornetQBuffer fileBuffer = HornetQBuffers.wrappedBuffer(buffer2);
        fileBuffer.writerIndex(fileBuffer.capacity());
        while (fileBuffer.readable()) {
            int position = fileBuffer.readerIndex();
            byte byteRead = fileBuffer.readByte();
            if (byteRead == 123) {
                if (fileBuffer.readerIndex() + 4 >= fileBuffer.capacity()) continue;
                int messageSize = fileBuffer.readInt();
                int oldPos = fileBuffer.readerIndex();
                if (fileBuffer.readerIndex() + messageSize < fileBuffer.capacity() && fileBuffer.getByte(oldPos + messageSize) == 125) {
                    PagedMessageImpl msg = new PagedMessageImpl();
                    msg.decode(fileBuffer);
                    byte b = fileBuffer.readByte();
                    if (b != 125) {
                        throw new IllegalStateException("Internal error, it wasn't possible to locate END_BYTE " + b);
                    }
                    msg.initMessage(storage);
                    if (isTrace) {
                        log.trace("Reading message " + msg + " on pageId=" + this.pageId + " for address=" + this.storeName);
                    }
                    messages.add(msg);
                    continue;
                }
                this.markFileAsSuspect(position, messages.size());
                break;
            }
            this.markFileAsSuspect(position, messages.size());
            break;
        }
        this.numberOfMessages.set(messages.size());
        return messages;
    }

    @Override
    public void write(PagedMessage message) throws Exception {
        ByteBuffer buffer = this.fileFactory.newBuffer(message.getEncodeSize() + 6);
        HornetQBuffer wrap = HornetQBuffers.wrappedBuffer(buffer);
        wrap.clear();
        wrap.writeByte((byte)123);
        wrap.writeInt(0);
        int startIndex = wrap.writerIndex();
        message.encode(wrap);
        int endIndex = wrap.writerIndex();
        wrap.setInt(1, endIndex - startIndex);
        wrap.writeByte((byte)125);
        buffer.rewind();
        this.file.writeDirect(buffer, false);
        if (this.pageCache != null) {
            this.pageCache.addLiveMessage(message);
        }
        this.numberOfMessages.incrementAndGet();
        this.size.addAndGet(buffer.limit());
        this.storageManager.pageWrite(message, this.pageId);
    }

    @Override
    public void sync() throws Exception {
        this.file.sync();
    }

    @Override
    public void open() throws Exception {
        this.file.open();
        this.size.set((int)this.file.size());
        this.file.position(0L);
    }

    @Override
    public void close() throws Exception {
        if (this.storageManager != null) {
            this.storageManager.pageClosed(this.storeName, this.pageId);
        }
        if (this.pageCache != null) {
            this.pageCache.close();
            this.pageCache = null;
        }
        this.file.close();
    }

    @Override
    public boolean delete(PagedMessage[] messages) throws Exception {
        if (this.storageManager != null) {
            this.storageManager.pageDeleted(this.storeName, this.pageId);
        }
        if (isDebug) {
            log.debug("Deleting pageId=" + this.pageId + " on store " + this.storeName);
        }
        if (messages != null) {
            for (PagedMessage msg : messages) {
                if (!msg.getMessage().isLargeMessage()) continue;
                LargeServerMessage lmsg = (LargeServerMessage)msg.getMessage();
                lmsg.decrementDelayDeletionCount();
            }
        }
        try {
            if (this.suspiciousRecords) {
                log.warn("File " + this.file.getFileName() + " being renamed to " + this.file.getFileName() + ".invalidPage as it was loaded partially. Please verify your data.");
                this.file.renameTo(this.file.getFileName() + ".invalidPage");
            } else {
                this.file.delete();
            }
            return true;
        }
        catch (Exception e) {
            log.warn("Error while deleting page file", e);
            return false;
        }
    }

    @Override
    public int getNumberOfMessages() {
        return this.numberOfMessages.intValue();
    }

    @Override
    public int getSize() {
        return this.size.intValue();
    }

    public String toString() {
        return "PageImpl::pageID=" + this.pageId + ", file=" + this.file;
    }

    @Override
    public int compareTo(Page otherPage) {
        return otherPage.getPageId() - this.pageId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.pageId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageImpl other = (PageImpl)obj;
        return this.pageId == other.pageId;
    }

    private void markFileAsSuspect(int position, int msgNumber) {
        log.warn("Page file had incomplete records at position " + position + " at record number " + msgNumber);
        this.suspiciousRecords = true;
    }
}

