/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.rmi.ir;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.as.jacorb.rmi.ir.ContainerImpl;
import org.jboss.as.jacorb.rmi.ir.IRConstructionException;
import org.jboss.as.jacorb.rmi.ir.LocalContained;
import org.jboss.as.jacorb.rmi.ir.LocalContainer;
import org.jboss.as.jacorb.rmi.ir.SequenceDefImpl;
import org.jboss.as.jacorb.rmi.ir.ValueBoxDefImpl;
import org.jboss.logging.Logger;
import org.omg.CORBA.ArrayDef;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.Contained;
import org.omg.CORBA.ContainedHelper;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.FixedDef;
import org.omg.CORBA.IDLType;
import org.omg.CORBA.IRObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.PrimitiveDef;
import org.omg.CORBA.PrimitiveKind;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.RepositoryOperations;
import org.omg.CORBA.RepositoryPOATie;
import org.omg.CORBA.SequenceDef;
import org.omg.CORBA.StringDef;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UserException;
import org.omg.CORBA.WstringDef;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

class RepositoryImpl
extends ContainerImpl
implements RepositoryOperations,
LocalContainer {
    private static final Logger logger = Logger.getLogger(RepositoryImpl.class);
    ORB orb = null;
    POA poa = null;
    private byte[] oid = null;
    private String oidPrefix = null;
    private String anonOidPrefix = null;
    Map sequenceMap = new HashMap();
    Map sequenceIdMap = new HashMap();
    private Repository ref = null;
    private long nextPOAId = 1L;

    public RepositoryImpl(ORB orb, POA poa, String name) {
        super(DefinitionKind.dk_Repository, null);
        this.orb = orb;
        this.poa = poa;
        try {
            this.oid = name.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 encoding not supported.");
        }
        this.oidPrefix = name + ":";
        this.anonOidPrefix = this.oidPrefix + "anon";
        this.repository = this;
    }

    @Override
    public IRObject getReference() {
        if (this.ref == null) {
            this.ref = RepositoryHelper.narrow((Object)this.servantToReference((Servant)new RepositoryPOATie((RepositoryOperations)this)));
        }
        return this.ref;
    }

    @Override
    public void allDone() throws IRConstructionException {
        super.allDone();
        Iterator iter = this.sequenceMap.values().iterator();
        while (iter.hasNext()) {
            ((SequenceDefImpl)iter.next()).allDone();
        }
    }

    @Override
    public void shutdown() {
        for (long i = 1L; i < this.nextPOAId; ++i) {
            try {
                this.getPOA().deactivate_object(this.getAnonymousObjectId(i));
                continue;
            }
            catch (UserException ex) {
                logger.warn((java.lang.Object)"Could not deactivate anonymous IR object", (Throwable)ex);
            }
        }
        super.shutdown();
    }

    public Contained lookup_id(String search_id) {
        logger.debug((java.lang.Object)("RepositoryImpl.lookup_id(\"" + search_id + "\") entered."));
        LocalContained c = this._lookup_id(search_id);
        if (c == null) {
            return null;
        }
        return ContainedHelper.narrow((Object)c.getReference());
    }

    public TypeCode get_canonical_typecode(TypeCode tc) {
        logger.debug((java.lang.Object)"RepositoryImpl.get_canonical_typecode() entered.");
        return null;
    }

    public PrimitiveDef get_primitive(PrimitiveKind kind) {
        logger.debug((java.lang.Object)"RepositoryImpl.get_primitive() entered.");
        return null;
    }

    public StringDef create_string(int bound) {
        throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
    }

    public WstringDef create_wstring(int bound) {
        throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
    }

    public SequenceDef create_sequence(int bound, IDLType element_type) {
        throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
    }

    public ArrayDef create_array(int length, IDLType element_type) {
        throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
    }

    public FixedDef create_fixed(short digits, short scale) {
        throw new BAD_INV_ORDER("Cannot change RMI/IIOP mapping.");
    }

    LocalContained _lookup_id(String search_id) {
        logger.debug((java.lang.Object)("RepositoryImpl._lookup_id(\"" + search_id + "\") entered."));
        if (search_id.startsWith("RMI:[")) {
            return (ValueBoxDefImpl)this.sequenceIdMap.get(search_id);
        }
        String name = this.scopedName(search_id);
        logger.debug((java.lang.Object)("RepositoryImpl._lookup_id(): scopedName=\"" + this.scopedName(search_id) + "\""));
        LocalContained ret = name == null ? null : this._lookup(name);
        logger.debug((java.lang.Object)("RepositoryImpl._lookup_id(): returning " + (ret == null ? "null" : "NOT null")));
        return ret;
    }

    SequenceDefImpl getSequenceImpl(TypeCode typeCode) {
        return (SequenceDefImpl)this.sequenceMap.get(typeCode);
    }

    void putSequenceImpl(String id, TypeCode typeCode, SequenceDefImpl sequence, ValueBoxDefImpl valueBox) {
        this.sequenceIdMap.put(id, valueBox);
        this.sequenceMap.put(typeCode, sequence);
    }

    String getObjectIdPrefix() {
        return this.oidPrefix;
    }

    @Override
    protected byte[] getObjectId() {
        return (byte[])this.oid.clone();
    }

    protected byte[] getAnonymousObjectId(long n) {
        String s = this.anonOidPrefix + Long.toString(n);
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 encoding not supported.");
        }
    }

    protected byte[] getNextObjectId() {
        return this.getAnonymousObjectId(this.nextPOAId++);
    }

    private String scopedName(String id) {
        if (id == null) {
            return null;
        }
        if (id.startsWith("IDL:")) {
            if ("IDL:omg.org/CORBA/Object:1.0".equals(id) || "IDL:omg.org/CORBA/ValueBase:1.0".equals(id)) {
                return null;
            }
            int idx2 = id.indexOf(58, 4);
            if (idx2 == -1) {
                return null;
            }
            String base = id.substring(4, id.indexOf(58, 4));
            if (base.startsWith("omg.org")) {
                base = "org/omg" + base.substring(7);
            }
            if (base.startsWith("w3c.org")) {
                base = "org/w3c" + base.substring(7);
            }
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < base.length(); ++i) {
                char c = base.charAt(i);
                if (c != '/') {
                    b.append(c);
                    continue;
                }
                b.append("::");
            }
            return b.toString();
        }
        if (id.startsWith("RMI:")) {
            int idx2 = id.indexOf(58, 4);
            if (idx2 == -1) {
                return null;
            }
            String base = id.substring(4, id.indexOf(58, 4));
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < base.length(); ++i) {
                char c = base.charAt(i);
                if (c != '.') {
                    b.append(c);
                    continue;
                }
                b.append("::");
            }
            return b.toString();
        }
        return null;
    }
}

