/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.transaction;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.jpa.JpaLogger;
import org.jboss.as.jpa.JpaMessages;
import org.jboss.as.jpa.container.EntityManagerMetadata;
import org.jboss.as.jpa.container.EntityManagerUtil;
import org.jboss.tm.TxUtils;

public class TransactionUtil {
    private static final TransactionUtil INSTANCE = new TransactionUtil();
    private static volatile TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private static volatile TransactionManager transactionManager;

    public static TransactionUtil getInstance() {
        return INSTANCE;
    }

    public static void setTransactionManager(TransactionManager tm) {
        if (transactionManager == null) {
            transactionManager = tm;
        }
    }

    public static TransactionManager getTransactionManager() {
        return transactionManager;
    }

    public static void setTransactionSynchronizationRegistry(TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        if (TransactionUtil.transactionSynchronizationRegistry == null) {
            TransactionUtil.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        }
    }

    public boolean isInTx() {
        Transaction tx = this.getTransaction();
        return tx != null && TxUtils.isActive((Transaction)tx);
    }

    public void registerExtendedUnderlyingWithTransaction(String scopedPuName, EntityManager xpc, EntityManager underlyingEntityManager) {
        this.registerSynchronization(xpc, scopedPuName, false);
        underlyingEntityManager.joinTransaction();
        this.putEntityManagerInTransactionRegistry(scopedPuName, xpc);
    }

    public EntityManager getTransactionScopedEntityManager(String puScopedName) {
        return this.getEntityManagerInTransactionRegistry(puScopedName);
    }

    public EntityManager getOrCreateTransactionScopedEntityManager(EntityManagerFactory emf, String scopedPuName, Map properties) {
        EntityManager entityManager = this.getEntityManagerInTransactionRegistry(scopedPuName);
        if (entityManager == null) {
            entityManager = EntityManagerUtil.createEntityManager(emf, properties);
            if (JpaLogger.JPA_LOGGER.isDebugEnabled()) {
                JpaLogger.JPA_LOGGER.debugf("%s: created entity manager session %s", (Object)TransactionUtil.getEntityManagerDetails(entityManager), (Object)this.getTransaction().toString());
            }
            boolean autoCloseEntityManager = true;
            this.registerSynchronization(entityManager, scopedPuName, autoCloseEntityManager);
            this.putEntityManagerInTransactionRegistry(scopedPuName, entityManager);
        } else if (JpaLogger.JPA_LOGGER.isDebugEnabled()) {
            JpaLogger.JPA_LOGGER.debugf("%s: reuse entity manager session already in tx %s", (Object)TransactionUtil.getEntityManagerDetails(entityManager), (Object)this.getTransaction().toString());
        }
        return entityManager;
    }

    private void registerSynchronization(EntityManager entityManager, String puScopedName, boolean closeEMAtTxEnd) {
        Transaction tx = this.getTransaction();
        try {
            tx.registerSynchronization((Synchronization)new SessionSynchronization(entityManager, closeEMAtTxEnd, puScopedName));
        }
        catch (RollbackException e) {
            throw new RuntimeException(e);
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    private Transaction getTransaction() {
        try {
            return transactionManager.getTransaction();
        }
        catch (SystemException e) {
            throw JpaMessages.MESSAGES.errorGettingTransaction((Exception)((Object)e));
        }
    }

    public static TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return transactionSynchronizationRegistry;
    }

    private static String currentThread() {
        return Thread.currentThread().getName();
    }

    private static String getEntityManagerDetails(EntityManager manager) {
        String result = TransactionUtil.currentThread() + ":";
        try {
            EntityManagerMetadata metadata = (EntityManagerMetadata)manager.unwrap(EntityManagerMetadata.class);
            if (metadata != null) {
                result = result + metadata.getPuName() + (metadata.isTransactionScopedEntityManager() ? " [XPC]" : " [transactional]");
            }
        }
        catch (PersistenceException ignoreUnhandled) {
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
        return result;
    }

    private EntityManager getEntityManagerInTransactionRegistry(String scopedPuName) {
        return (EntityManager)TransactionUtil.getTransactionSynchronizationRegistry().getResource((Object)scopedPuName);
    }

    private void putEntityManagerInTransactionRegistry(String scopedPuName, EntityManager entityManager) {
        TransactionUtil.getTransactionSynchronizationRegistry().putResource((Object)scopedPuName, (Object)entityManager);
    }

    private static class SessionSynchronization
    implements Synchronization {
        private EntityManager manager;
        private boolean closeAtTxCompletion;
        private String scopedPuName;

        public SessionSynchronization(EntityManager session, boolean close, String scopedPuName) {
            this.manager = session;
            this.closeAtTxCompletion = close;
            this.scopedPuName = scopedPuName;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (this.closeAtTxCompletion) {
                if (JpaLogger.JPA_LOGGER.isDebugEnabled()) {
                    JpaLogger.JPA_LOGGER.debugf("%s: closing entity managersession", (Object)TransactionUtil.getEntityManagerDetails(this.manager));
                }
                this.manager.close();
            }
            TransactionUtil.getInstance().putEntityManagerInTransactionRegistry(this.scopedPuName, null);
        }
    }
}

