/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;

final class ReflectionUtils {
    private ReflectionUtils() {
    }

    static Method getGetter(ClassReflectionIndex<?> classIndex, String propertyName) {
        String getterName = "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        String iserName = "is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        Iterator methods = classIndex.getMethods().iterator();
        Method method = null;
        String methodName = null;
        while (methods.hasNext()) {
            method = (Method)methods.next();
            methodName = method.getName();
            if (!getterName.equals(methodName) && !iserName.equals(methodName) || method.getParameterTypes().length != 0) continue;
            return method;
        }
        throw new IllegalStateException("No such get method for property '" + propertyName + "' found on " + classIndex.getIndexedClass());
    }

    static Method getSetter(ClassReflectionIndex<?> classIndex, String propertyName) {
        String setterName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        Iterator methods = classIndex.getMethods().iterator();
        Method method = null;
        String methodName = null;
        while (methods.hasNext()) {
            method = (Method)methods.next();
            methodName = method.getName();
            if (!setterName.equals(methodName) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        throw new IllegalStateException("No such set method for property '" + propertyName + "' found on " + classIndex.getIndexedClass());
    }

    static Method getMethod(ClassReflectionIndex<?> classIndex, String methodName, Class<?>[] types, boolean fail) {
        Collection methods = classIndex.getMethods(methodName, (Class[])types);
        if (methods.size() == 1) {
            return (Method)methods.iterator().next();
        }
        if (fail) {
            throw new IllegalStateException(ReflectionUtils.noSuchMethod(classIndex, methodName, types));
        }
        return null;
    }

    static Object newInstance(Constructor<?> constructor, Object[] args) throws DeploymentUnitProcessingException {
        try {
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new DeploymentUnitProcessingException("Component class not instantiated", (Throwable)e);
        }
    }

    static Class<?> getClass(String className, ClassLoader classLoader) throws DeploymentUnitProcessingException {
        try {
            return Class.forName(className, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentUnitProcessingException("Component class not found", (Throwable)e);
        }
    }

    private static String noSuchMethod(ClassReflectionIndex<?> classIndex, String methodName, Class<?>[] parameterTypes) {
        StringBuffer message = new StringBuffer();
        message.append("No such method '");
        message.append(methodName);
        ReflectionUtils.appendParameterList(message, parameterTypes);
        message.append("' found on ").append(classIndex.getIndexedClass());
        return message.toString();
    }

    private static void appendParameterList(StringBuffer stringBuffer, Class<?>[] parameterTypes) {
        stringBuffer.append('(');
        if (parameterTypes != null && parameterTypes.length > 0) {
            stringBuffer.append(parameterTypes[0]);
            for (int i = 1; i < parameterTypes.length; ++i) {
                stringBuffer.append(", ").append(parameterTypes[i]);
            }
        }
        stringBuffer.append(')');
    }
}

