/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.config.Configuration;

public enum Mode {
    SYNC(true),
    ASYNC(false);

    private final boolean sync;

    private Mode(boolean sync) {
        this.sync = sync;
    }

    public static Mode forCacheMode(Configuration.CacheMode mode) {
        return mode.isSynchronous() ? SYNC : ASYNC;
    }

    public Configuration.CacheMode apply(Configuration.CacheMode mode) {
        return this.sync ? mode.toSync() : mode.toAsync();
    }

    public boolean isSynchronous() {
        return this.sync;
    }

    public String toString() {
        return this.name().toLowerCase();
    }
}

