/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.metadata.parser.servlet.WebMetaDataParser;
import org.jboss.metadata.parser.util.NoopXmlResolver;
import org.jboss.vfs.VirtualFile;

public class WebParsingDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final String WEB_XML = "WEB-INF/web.xml";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        VirtualFile alternateDescriptor = (VirtualFile)deploymentRoot.getAttachment(org.jboss.as.ee.structure.Attachments.ALTERNATE_WEB_DEPLOYMENT_DESCRIPTOR);
        VirtualFile webXml = alternateDescriptor != null ? alternateDescriptor : deploymentRoot.getRoot().getChild(WEB_XML);
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        assert (warMetaData != null);
        if (webXml.exists()) {
            InputStream is = null;
            try {
                is = webXml.openStream();
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                inputFactory.setXMLResolver(NoopXmlResolver.create());
                XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(is);
                warMetaData.setWebMetaData(WebMetaDataParser.parse((XMLStreamReader)xmlReader));
            }
            catch (XMLStreamException e) {
                throw new DeploymentUnitProcessingException("Failed to parse " + webXml + " at [" + e.getLocation().getLineNumber() + "," + e.getLocation().getColumnNumber() + "]");
            }
            catch (IOException e) {
                throw new DeploymentUnitProcessingException("Failed to parse " + webXml, (Throwable)e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

