/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.remoting.AbstractOutboundConnectionResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

abstract class AbstractOutboundConnectionAddHandler
extends AbstractAddStepHandler {
    AbstractOutboundConnectionAddHandler() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AbstractOutboundConnectionResourceDefinition.CONNECTION_CREATION_OPTIONS.validateAndSet(operation, model);
    }

    protected static OptionMap getConnectionCreationOptions(ModelNode model) {
        if (!model.hasDefined("connection-creation-options")) {
            return OptionMap.EMPTY;
        }
        OptionMap.Builder optionMapBuilder = OptionMap.builder();
        List connectionCreationProps = model.get("connection-creation-options").asPropertyList();
        for (Property property : connectionCreationProps) {
            String xnioOptionName = property.getName();
            String value = property.getValue().asString();
            String fullyQualifiedOptionName = Options.class.getName() + "." + xnioOptionName;
            Option connectionCreationOption = Option.fromString((String)fullyQualifiedOptionName, (ClassLoader)Options.class.getClassLoader());
            optionMapBuilder.parse(connectionCreationOption, value);
        }
        return optionMapBuilder.getMap();
    }
}

