/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import org.infinispan.configuration.global.ExecutorFactoryConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationChildBuilder;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfigurationBuilder;
import org.infinispan.configuration.global.ScheduledExecutorFactoryConfigurationBuilder;
import org.infinispan.configuration.global.SerializationConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfigurationBuilder;

public class GlobalConfigurationBuilder
implements GlobalConfigurationChildBuilder {
    private ClassLoader cl = Thread.currentThread().getContextClassLoader();
    private final TransportConfigurationBuilder transport = new TransportConfigurationBuilder(this);
    private final GlobalJmxStatisticsConfigurationBuilder globalJmxStatistics = new GlobalJmxStatisticsConfigurationBuilder(this);
    private final SerializationConfigurationBuilder serialization = new SerializationConfigurationBuilder(this);
    private final ExecutorFactoryConfigurationBuilder asyncTransportExecutor;
    private final ExecutorFactoryConfigurationBuilder asyncListenerExecutor = new ExecutorFactoryConfigurationBuilder(this);
    private final ScheduledExecutorFactoryConfigurationBuilder evictionScheduledExecutor;
    private final ScheduledExecutorFactoryConfigurationBuilder replicationQueueScheduledExecutor;
    private final ShutdownConfigurationBuilder shutdown;

    public GlobalConfigurationBuilder() {
        this.asyncTransportExecutor = new ExecutorFactoryConfigurationBuilder(this);
        this.evictionScheduledExecutor = new ScheduledExecutorFactoryConfigurationBuilder(this);
        this.replicationQueueScheduledExecutor = new ScheduledExecutorFactoryConfigurationBuilder(this);
        this.shutdown = new ShutdownConfigurationBuilder(this);
    }

    public GlobalConfigurationBuilder clusteredDefault() {
        this.transport().defaultTransport().clearProperties().asyncTransportExecutor().addProperty("threadNamePrefix", "asyncTransportThread");
        return this;
    }

    public GlobalConfigurationBuilder nonClusteredDefault() {
        this.transport().clearTransport().clearProperties();
        return this;
    }

    protected ClassLoader getClassLoader() {
        return this.cl;
    }

    public GlobalConfigurationBuilder classLoader(ClassLoader cl) {
        this.cl = cl;
        return this;
    }

    @Override
    public TransportConfigurationBuilder transport() {
        return this.transport;
    }

    @Override
    public GlobalJmxStatisticsConfigurationBuilder globalJmxStatistics() {
        return this.globalJmxStatistics;
    }

    @Override
    public SerializationConfigurationBuilder serialization() {
        return this.serialization;
    }

    @Override
    public ExecutorFactoryConfigurationBuilder asyncTransportExecutor() {
        return this.asyncTransportExecutor;
    }

    @Override
    public ExecutorFactoryConfigurationBuilder asyncListenerExecutor() {
        return this.asyncListenerExecutor;
    }

    @Override
    public ScheduledExecutorFactoryConfigurationBuilder evictionScheduledExecutor() {
        return this.evictionScheduledExecutor;
    }

    @Override
    public ScheduledExecutorFactoryConfigurationBuilder replicationQueueScheduledExecutor() {
        return this.replicationQueueScheduledExecutor;
    }

    @Override
    public ShutdownConfigurationBuilder shutdown() {
        return this.shutdown;
    }

    @Override
    public GlobalConfiguration build() {
        return new GlobalConfiguration(this.asyncListenerExecutor.create(), this.asyncTransportExecutor.create(), this.evictionScheduledExecutor.create(), this.replicationQueueScheduledExecutor.create(), this.globalJmxStatistics.create(), this.transport.create(), this.serialization.create(), this.shutdown.create(), this.cl);
    }
}

