/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.responses;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.util.Util;

public class ExtendedResponse
extends ValidResponse {
    private final boolean replayIgnoredRequests;
    private final Response response;

    public ExtendedResponse(Response response, boolean replayIgnoredRequests) {
        this.response = response;
        this.replayIgnoredRequests = replayIgnoredRequests;
    }

    public boolean isReplayIgnoredRequests() {
        return this.replayIgnoredRequests;
    }

    public Response getResponse() {
        return this.response;
    }

    @Override
    public boolean isSuccessful() {
        return this.response.isSuccessful();
    }

    public static class Externalizer
    extends AbstractExternalizer<ExtendedResponse> {
        public void writeObject(ObjectOutput output, ExtendedResponse er) throws IOException {
            output.writeBoolean(er.replayIgnoredRequests);
            output.writeObject(er.response);
        }

        public ExtendedResponse readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            boolean replayIgnoredRequests = input.readBoolean();
            Response response = (Response)input.readObject();
            return new ExtendedResponse(response, replayIgnoredRequests);
        }

        public Integer getId() {
            return 6;
        }

        public Set<Class<? extends ExtendedResponse>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{ExtendedResponse.class});
        }
    }
}

