/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.HandlerUpdateProperties;
import org.jboss.as.logging.ModelParser;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.handlers.SizeRotatingFileHandler;

public class SizeRotatingHandlerUpdateProperties
extends HandlerUpdateProperties<SizeRotatingFileHandler> {
    static final SizeRotatingHandlerUpdateProperties INSTANCE = new SizeRotatingHandlerUpdateProperties();

    private SizeRotatingHandlerUpdateProperties() {
        super(new AttributeDefinition[]{CommonAttributes.APPEND, CommonAttributes.AUTOFLUSH, CommonAttributes.MAX_BACKUP_INDEX, CommonAttributes.ROTATE_SIZE});
    }

    @Override
    protected boolean applyUpdateToRuntime(OperationContext context, String handlerName, ModelNode model, ModelNode originalModel, SizeRotatingFileHandler handler) throws OperationFailedException {
        ModelNode rotateSizeNode;
        ModelNode maxBackupIndex;
        ModelNode append;
        ModelNode autoflush = CommonAttributes.AUTOFLUSH.resolveModelAttribute(context, model);
        if (autoflush.isDefined()) {
            handler.setAutoFlush(autoflush.asBoolean());
        }
        if ((append = CommonAttributes.APPEND.resolveModelAttribute(context, model)).isDefined()) {
            handler.setAppend(append.asBoolean());
        }
        if ((maxBackupIndex = CommonAttributes.MAX_BACKUP_INDEX.resolveModelAttribute(context, model)).isDefined()) {
            handler.setMaxBackupIndex(maxBackupIndex.asInt());
        }
        if ((rotateSizeNode = CommonAttributes.ROTATE_SIZE.resolveModelAttribute(context, model)).isDefined()) {
            handler.setRotateSize(ModelParser.parseSize(rotateSizeNode));
        }
        return false;
    }

    @Override
    protected void revertUpdateToRuntime(OperationContext context, String handlerName, ModelNode model, ModelNode originalModel, SizeRotatingFileHandler handler) throws OperationFailedException {
        ModelNode rotateSizeNode;
        ModelNode maxBackupIndex;
        ModelNode append;
        ModelNode autoflush = CommonAttributes.AUTOFLUSH.resolveModelAttribute(context, originalModel);
        if (autoflush.isDefined()) {
            handler.setAutoFlush(autoflush.asBoolean());
        }
        if ((append = CommonAttributes.APPEND.resolveModelAttribute(context, originalModel)).isDefined()) {
            handler.setAppend(append.asBoolean());
        }
        if ((maxBackupIndex = CommonAttributes.MAX_BACKUP_INDEX.resolveModelAttribute(context, originalModel)).isDefined()) {
            handler.setMaxBackupIndex(maxBackupIndex.asInt());
        }
        if ((rotateSizeNode = CommonAttributes.ROTATE_SIZE.resolveModelAttribute(context, originalModel)).isDefined()) {
            handler.setRotateSize(ModelParser.parseSize(rotateSizeNode));
        }
    }
}

