/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.Set;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.ViewManagedReferenceFactory;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.remote.RemoteViewManagedReferenceFactory;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public class EjbInjectionSource
extends InjectionSource {
    private final String beanName;
    private final String typeName;
    private final String bindingName;
    private volatile ServiceName resolvedViewName;
    private volatile RemoteViewManagedReferenceFactory remoteFactory;
    private volatile String error = null;

    public EjbInjectionSource(String beanName, String typeName, String bindingName) {
        this.beanName = beanName;
        this.typeName = typeName;
        this.bindingName = bindingName;
    }

    public EjbInjectionSource(String typeName, String bindingName) {
        this.bindingName = bindingName;
        this.beanName = null;
        this.typeName = typeName;
    }

    public void getResourceValue(InjectionSource.ResolutionContext resolutionContext, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        if (this.error != null) {
            throw new DeploymentUnitProcessingException(this.error);
        }
        if (this.remoteFactory != null) {
            injector.inject((Object)this.remoteFactory);
        } else {
            serviceBuilder.addDependency(this.resolvedViewName, ComponentView.class, (Injector)new ViewManagedReferenceFactory.Injector(injector));
        }
    }

    public void resolve(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ServiceName serviceName;
        EJBViewDescription ejbViewDescription;
        Set<ViewDescription> componentsForViewName = this.getViews(phaseContext);
        if (componentsForViewName.isEmpty()) {
            this.error = "No component found for type '" + this.typeName + "' with name " + this.beanName + " for binding " + this.bindingName;
            return;
        }
        if (componentsForViewName.size() > 1) {
            this.error = "More than 1 component found for type '" + this.typeName + "' and bean name " + this.beanName + " for binding " + this.bindingName;
            return;
        }
        ViewDescription description = componentsForViewName.iterator().next();
        if (description instanceof EJBViewDescription && ((ejbViewDescription = (EJBViewDescription)description).getMethodIntf() == MethodIntf.REMOTE || ejbViewDescription.getMethodIntf() == MethodIntf.HOME)) {
            EJBComponentDescription componentDescription = (EJBComponentDescription)description.getComponentDescription();
            EEModuleDescription moduleDescription = componentDescription.getModuleDescription();
            String earApplicationName = moduleDescription.getEarApplicationName();
            this.remoteFactory = new RemoteViewManagedReferenceFactory(earApplicationName, moduleDescription.getModuleName(), moduleDescription.getDistinctName(), componentDescription.getComponentName(), description.getViewClassName(), componentDescription.isStateful());
        }
        this.resolvedViewName = serviceName = description.getServiceName();
    }

    private Set<ViewDescription> getViews(DeploymentPhaseContext phaseContext) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEApplicationDescription applicationDescription = (EEApplicationDescription)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_DESCRIPTION);
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
        Set componentsForViewName = this.beanName != null ? applicationDescription.getComponents(this.beanName, this.typeName, deploymentRoot.getRoot()) : applicationDescription.getComponentsForViewName(this.typeName);
        return componentsForViewName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EjbInjectionSource)) {
            return false;
        }
        if (this.error != null) {
            throw new RuntimeException(this.error);
        }
        if (this.resolvedViewName == null) {
            throw new RuntimeException("Error equals() cannot be called before resolve()");
        }
        EjbInjectionSource other = (EjbInjectionSource)((Object)o);
        return EjbInjectionSource.eq(this.typeName, other.typeName) && EjbInjectionSource.eq(this.resolvedViewName, other.resolvedViewName);
    }

    public int hashCode() {
        return this.typeName.hashCode();
    }

    private static boolean eq(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }
}

