/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.protocol.Codec10;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public class Codec11
extends Codec10 {
    private static final Log log = LogFactory.getLog(Codec11.class, Log.class);

    @Override
    public HeaderParams writeHeader(Transport transport, HeaderParams params) {
        return this.writeHeader(transport, params, (byte)11);
    }

    @Override
    protected void readNewTopologyAndHash(Transport transport, AtomicInteger topologyId) {
        int newTopologyId = transport.readVInt();
        topologyId.set(newTopologyId);
        int numKeyOwners = transport.readUnsignedShort();
        short hashFctVersion = transport.readByte();
        if (hashFctVersion == 0) {
            log.trace("Not using a consistent hash function (hash function version == 0).");
            transport.readVInt();
            int clusterSize = transport.readVInt();
            transport.readVInt();
            HashSet<SocketAddress> addresses = new HashSet<SocketAddress>();
            for (int i = 0; i < clusterSize; ++i) {
                String host = transport.readString();
                int port = transport.readUnsignedShort();
                log.tracef("Server read: %s:%d", host, port);
                addresses.add(new InetSocketAddress(host, port));
            }
            if (log.isInfoEnabled()) {
                log.newTopology(addresses);
            }
            transport.getTransportFactory().updateServers(addresses);
        } else {
            ConsistentHash ch = transport.getTransportFactory().getConsistentHashFactory().newConsistentHash(hashFctVersion);
            int hashSpace = transport.readVInt();
            int clusterSize = transport.readVInt();
            int numVirtualNodes = transport.readVInt();
            log.tracef("Topology change request: newTopologyId=%d, numKeyOwners=%d, hashFunctionVersion=%d, hashSpaceSize=%d, clusterSize=%d, numVirtualNodes=%d", new Object[]{newTopologyId, numKeyOwners, hashFctVersion, hashSpace, clusterSize, numVirtualNodes});
            LinkedHashMap<SocketAddress, Set<Integer>> servers2Hash = new LinkedHashMap<SocketAddress, Set<Integer>>();
            for (int i = 0; i < clusterSize; ++i) {
                String host = transport.readString();
                int port = transport.readUnsignedShort();
                log.tracef("Server read: %s:%d", host, port);
                int hashCode = this.calcNodeHashCode(host, port, ch);
                this.cacheHashCode(servers2Hash, host, port, hashCode);
                if (numVirtualNodes <= 1) continue;
                this.calcVirtualHashCodes(ch, numVirtualNodes, servers2Hash, host, port);
            }
            if (log.isInfoEnabled()) {
                log.newTopology(servers2Hash.keySet());
            }
            transport.getTransportFactory().updateServers(servers2Hash.keySet());
            transport.getTransportFactory().updateHashFunction(servers2Hash, numKeyOwners, hashFctVersion, hashSpace);
        }
    }

    private void calcVirtualHashCodes(ConsistentHash ch, int numVirtualNodes, Map<SocketAddress, Set<Integer>> servers2Hash, String host, int port) {
        for (int j = 1; j < numVirtualNodes; ++j) {
            int hashCode = this.calcVNodeHashCode(host, port, ch, j);
            this.cacheHashCode(servers2Hash, host, port, hashCode);
        }
    }

    private void cacheHashCode(Map<SocketAddress, Set<Integer>> servers2Hash, String host, int port, int hashCode) {
        InetSocketAddress address = new InetSocketAddress(host, port);
        Set<Integer> hashes = servers2Hash.get(address);
        if (hashes == null) {
            hashes = new HashSet<Integer>();
            servers2Hash.put(address, hashes);
        }
        hashes.add(hashCode);
        log.tracef("Hash code is: %d", hashCode);
    }

    private int calcNodeHashCode(String host, int port, ConsistentHash ch) {
        byte[] addressBytes = String.format("%s:%d", host, port).getBytes(HotRodConstants.HOTROD_STRING_CHARSET);
        return ch.getNormalizedHash(Arrays.hashCode(addressBytes));
    }

    private int calcVNodeHashCode(String host, int port, ConsistentHash ch, int id) {
        int addrHashCode = this.calcNodeHashCode(host, port, ch);
        int result = id;
        result = 31 * result + addrHashCode;
        return result;
    }
}

