/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.DeploymentDescription;
import org.jboss.as.controller.operations.validation.AbstractParameterValidator;
import org.jboss.as.controller.operations.validation.ChainedParameterValidator;
import org.jboss.as.controller.operations.validation.ListValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersOfValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.domain.controller.operations.deployment.AbstractDeploymentHandler;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.server.deployment.repository.api.ContentRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentFullReplaceHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "full-replace-deployment";
    private final ContentRepository contentRepository;
    private final FileRepository fileRepository;
    private final ParametersValidator validator = new ParametersValidator();
    private final ParametersValidator unmanagedContentValidator = new ParametersValidator();
    private final ParametersValidator managedContentValidator = new ParametersValidator();

    public DeploymentFullReplaceHandler(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
        this.fileRepository = null;
        this.init();
    }

    public DeploymentFullReplaceHandler(FileRepository fileRepository) {
        this.contentRepository = null;
        this.fileRepository = fileRepository;
        this.init();
    }

    private void init() {
        this.validator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, false));
        this.validator.registerValidator("runtime-name", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false));
        ParametersValidator contentValidator = new ParametersValidator();
        contentValidator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        contentValidator.registerValidator("archive", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN, true));
        contentValidator.registerValidator("path", (ParameterValidator)new StringLengthValidator(1, true));
        contentValidator.registerValidator("relative-to", (ParameterValidator)new ModelTypeValidator(ModelType.STRING, true));
        contentValidator.registerValidator("input-stream-index", (ParameterValidator)new ModelTypeValidator(ModelType.INT, true));
        contentValidator.registerValidator("bytes", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        contentValidator.registerValidator("url", (ParameterValidator)new StringLengthValidator(1, true));
        this.validator.registerValidator("content", ChainedParameterValidator.chain((ParameterValidator[])new ParameterValidator[]{new ListValidator((ParameterValidator)new ParametersOfValidator(contentValidator)), new AbstractParameterValidator(){

            public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
                AbstractDeploymentHandler.validateOnePieceOfContent(value);
            }
        }}));
        this.managedContentValidator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES));
        this.unmanagedContentValidator.registerValidator("archive", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN));
        this.unmanagedContentValidator.registerValidator("path", (ParameterValidator)new StringLengthValidator(1));
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentDescription.getFullReplaceDeploymentOperation((Locale)locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathElement deploymentPath;
        Resource root;
        Resource replaceNode;
        byte[] hash;
        this.validator.validate(operation);
        String name = operation.require("name").asString();
        String runtimeName = operation.hasDefined("runtime-name") ? operation.get("runtime-name").asString() : name;
        ModelNode content = operation.require("content").clone();
        ModelNode contentItemNode = content.require(0);
        if (contentItemNode.hasDefined("hash")) {
            this.managedContentValidator.validate(contentItemNode);
            hash = contentItemNode.require("hash").asBytes();
            if (this.contentRepository != null) {
                if (!this.contentRepository.hasContent(hash)) {
                    throw AbstractDeploymentHandler.createFailureException("No deployment content with hash %s is available in the deployment content repository.", HashUtil.bytesToHexString((byte[])hash));
                }
            } else {
                this.fileRepository.getDeploymentFiles(hash);
            }
        } else if (AbstractDeploymentHandler.hasValidContentAdditionParameterDefined(contentItemNode)) {
            if (this.contentRepository == null) {
                throw AbstractDeploymentHandler.createFailureException("A slave domain controller cannot accept deployment content uploads");
            }
            InputStream in = AbstractDeploymentHandler.getInputStream(context, contentItemNode);
            try {
                try {
                    hash = this.contentRepository.addContent(in);
                }
                catch (IOException e) {
                    throw AbstractDeploymentHandler.createFailureException(e.toString());
                }
            }
            finally {
                StreamUtils.safeClose((Closeable)in);
            }
            contentItemNode.clear();
            contentItemNode.get("hash").set(hash);
        } else {
            this.unmanagedContentValidator.validate(contentItemNode);
        }
        if ((replaceNode = (root = context.readResource(PathAddress.EMPTY_ADDRESS)).getChild(deploymentPath = PathElement.pathElement((String)"deployment", (String)name))) == null) {
            throw AbstractDeploymentHandler.createFailureException("No deployment with name %s found", name);
        }
        Resource deployment = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{PathElement.pathElement((String)"deployment", (String)name)}));
        ModelNode deployNode = deployment.getModel();
        deployNode.get("name").set(name);
        deployNode.get("runtime-name").set(runtimeName);
        deployNode.get("content").set(content);
        if (root.hasChild(PathElement.pathElement((String)"server-group"))) {
            for (Resource.ResourceEntry serverGroupResource : root.getChildren("server-group")) {
                Resource deploymentResource = serverGroupResource.getChild(deploymentPath);
                if (deploymentResource == null) continue;
                deploymentResource.getModel().get("runtime-name").set(runtimeName);
            }
        }
        DeploymentFullReplaceHandler.removeContentAdditions(replaceNode.getModel().require("content"));
        context.completeStep();
    }

    private static void removeAttributes(ModelNode node, Iterable<String> attributeNames) {
        for (String attributeName : attributeNames) {
            node.remove(attributeName);
        }
    }

    private static void removeContentAdditions(ModelNode content) {
        for (ModelNode contentItem : content.asList()) {
            DeploymentFullReplaceHandler.removeAttributes(contentItem, AbstractDeploymentHandler.CONTENT_ADDITION_PARAMETERS);
        }
    }
}

