/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.remoting.AbstractOutboundConnectionAddHandler;
import org.jboss.as.remoting.AbstractOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.RemoteOutboundConnectionAdd;
import org.jboss.as.remoting.RemoteOutboundConnectionService;
import org.jboss.as.remoting.RemoteOutboundConnnectionResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

class RemoteOutboundConnectionWriteHandler
extends AbstractWriteAttributeHandler<Boolean> {
    static final RemoteOutboundConnectionWriteHandler INSTANCE = new RemoteOutboundConnectionWriteHandler();

    private RemoteOutboundConnectionWriteHandler() {
        super(new AttributeDefinition[]{AbstractOutboundConnectionResourceDefinition.CONNECTION_CREATION_OPTIONS, RemoteOutboundConnnectionResourceDefinition.OUTBOUND_SOCKET_BINDING_REF});
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Boolean> handbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        boolean handback = this.applyModelToRuntime(context, operation, attributeName, model);
        handbackHolder.setHandback((Object)handback);
        return handback;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Boolean handback) throws OperationFailedException {
        if (handback != null && !handback.booleanValue()) {
            ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
            restored.get(attributeName).set(valueToRestore);
            this.applyModelToRuntime(context, operation, attributeName, restored);
        }
    }

    private boolean applyModelToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode model) throws OperationFailedException {
        boolean reloadRequired = false;
        String connectionName = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        ServiceName serviceName = RemoteOutboundConnectionService.OUTBOUND_CONNECTION_BASE_SERVICE_NAME.append(new String[]{connectionName});
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController sc = registry.getService(serviceName);
        if (sc != null && sc.getState() == ServiceController.State.UP) {
            RemoteOutboundConnectionService svc = (RemoteOutboundConnectionService)RemoteOutboundConnectionService.class.cast(sc.getValue());
            if (AbstractOutboundConnectionResourceDefinition.CONNECTION_CREATION_OPTIONS.getName().equals(attributeName)) {
                svc.setConnectionCreationOptions(AbstractOutboundConnectionAddHandler.getConnectionCreationOptions(model));
            } else {
                reloadRequired = true;
            }
        } else {
            context.removeService(serviceName);
            RemoteOutboundConnectionAdd.INSTANCE.installRuntimeService(context, connectionName, model, null);
        }
        return reloadRequired;
    }
}

