/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Locale;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.server.group.impl.GroupingHandlerConfiguration;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class GroupingHandlerAdd
implements OperationStepHandler,
DescriptionProvider {
    public static final GroupingHandlerAdd INSTANCE = new GroupingHandlerAdd();

    public static ModelNode getAddOperation(ModelNode address, ModelNode subModel) {
        ModelNode operation = Util.getOperation((String)"add", (ModelNode)address, (ModelNode)subModel);
        return operation;
    }

    private GroupingHandlerAdd() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress ourAddress = PathAddress.pathAddress((ModelNode)operation.require("address"));
        Resource subsystemRootResource = context.getRootResource().navigate(ourAddress.subAddress(0, ourAddress.size() - 1));
        if (subsystemRootResource.hasChildren("grouping-handler")) {
            throw new OperationFailedException(new ModelNode().set(MessagingMessages.MESSAGES.childResourceAlreadyExists("grouping-handler")));
        }
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        for (AttributeDefinition attributeDefinition : CommonAttributes.GROUPING_HANDLER_ATTRIBUTES) {
            attributeDefinition.validateAndSet(operation, model);
        }
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceName hqServiceName;
                    ServiceRegistry registry = context.getServiceRegistry(false);
                    ServiceController hqService = registry.getService(hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
                    if (hqService != null) {
                        context.reloadRequired();
                    }
                    if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                        context.revertReloadRequired();
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    public ModelNode getModelDescription(Locale locale) {
        return MessagingDescriptions.getGroupingHandlerAdd(locale);
    }

    static void addGroupingHandlerConfig(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("grouping-handler")) {
            Property prop = model.get("broadcast-group").asProperty();
            configuration.setGroupingHandlerConfiguration(GroupingHandlerAdd.createGroupingHandlerConfiguration(context, prop.getName(), prop.getValue()));
        }
    }

    static GroupingHandlerConfiguration createGroupingHandlerConfiguration(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        GroupingHandlerConfiguration.TYPE type = GroupingHandlerConfiguration.TYPE.valueOf((String)CommonAttributes.TYPE.resolveModelAttribute(context, model).asString());
        String address = CommonAttributes.GROUPING_HANDLER_ADDRESS.resolveModelAttribute(context, model).asString();
        int timeout = CommonAttributes.TIMEOUT.resolveModelAttribute(context, model).asInt();
        return new GroupingHandlerConfiguration(SimpleString.toSimpleString((String)name), type, SimpleString.toSimpleString((String)address), timeout);
    }
}

