/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.tomcat;

import java.util.List;
import org.jboss.as.webservices.WSMessages;
import org.jboss.as.webservices.metadata.model.EJBEndpoint;
import org.jboss.as.webservices.tomcat.SecurityMetaDataAccessorEJB;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBSecurityMetaData;

abstract class AbstractSecurityMetaDataAccessorEJB
implements SecurityMetaDataAccessorEJB {
    AbstractSecurityMetaDataAccessorEJB() {
    }

    @Override
    public String getSecurityDomain(Deployment dep) {
        String securityDomain = null;
        for (EJBEndpoint ejbEndpoint : this.getEjbEndpoints(dep)) {
            String nextSecurityDomain = ejbEndpoint.getSecurityDomain();
            securityDomain = this.getDomain(securityDomain, nextSecurityDomain);
        }
        return securityDomain;
    }

    @Override
    public SecurityRolesMetaData getSecurityRoles(Deployment dep) {
        SecurityRolesMetaData securityRolesMD = new SecurityRolesMetaData();
        for (EJBEndpoint ejbEndpoint : this.getEjbEndpoints(dep)) {
            for (String roleName : ejbEndpoint.getSecurityRoles()) {
                SecurityRoleMetaData securityRoleMD = new SecurityRoleMetaData();
                securityRoleMD.setRoleName(roleName);
                securityRolesMD.add((MappableMetaData)securityRoleMD);
            }
        }
        return securityRolesMD;
    }

    protected abstract List<EJBEndpoint> getEjbEndpoints(Deployment var1);

    @Override
    public String getAuthMethod(Endpoint endpoint) {
        EJBSecurityMetaData ejbSecurityMD = this.getEjbSecurityMetaData(endpoint);
        boolean hasEjbSecurityMD = ejbSecurityMD != null;
        return hasEjbSecurityMD ? ejbSecurityMD.getAuthMethod() : null;
    }

    @Override
    public boolean isSecureWsdlAccess(Endpoint endpoint) {
        EJBSecurityMetaData ejbSecurityMD = this.getEjbSecurityMetaData(endpoint);
        boolean hasEjbSecurityMD = ejbSecurityMD != null;
        return hasEjbSecurityMD ? ejbSecurityMD.getSecureWSDLAccess() : false;
    }

    @Override
    public String getTransportGuarantee(Endpoint endpoint) {
        EJBSecurityMetaData ejbSecurityMD = this.getEjbSecurityMetaData(endpoint);
        boolean hasEjbSecurityMD = ejbSecurityMD != null;
        return hasEjbSecurityMD ? ejbSecurityMD.getTransportGuarantee() : null;
    }

    private EJBSecurityMetaData getEjbSecurityMetaData(Endpoint endpoint) {
        String ejbName = endpoint.getShortName();
        Deployment dep = endpoint.getService().getDeployment();
        EJBArchiveMetaData ejbArchiveMD = (EJBArchiveMetaData)WSHelper.getOptionalAttachment((Deployment)dep, EJBArchiveMetaData.class);
        EJBMetaData ejbMD = ejbArchiveMD != null ? ejbArchiveMD.getBeanByEjbName(ejbName) : null;
        return ejbMD != null ? ejbMD.getSecurityMetaData() : null;
    }

    private String getDomain(String oldSecurityDomain, String nextSecurityDomain) {
        if (nextSecurityDomain == null) {
            return oldSecurityDomain;
        }
        if (oldSecurityDomain == null) {
            return nextSecurityDomain;
        }
        this.ensureSameDomains(oldSecurityDomain, nextSecurityDomain);
        return oldSecurityDomain;
    }

    private void ensureSameDomains(String oldSecurityDomain, String newSecurityDomain) {
        boolean domainsDiffer;
        boolean bl = domainsDiffer = !oldSecurityDomain.equals(newSecurityDomain);
        if (domainsDiffer) {
            throw WSMessages.MESSAGES.multipleSecurityDomainsDetected(oldSecurityDomain, newSecurityDomain);
        }
    }
}

