/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.List;
import org.jboss.as.controller.AbstractModelUpdateHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.HandlerFileService;
import org.jboss.as.logging.LogServices;
import org.jboss.as.server.services.path.AbstractPathService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

public class HandlerFileChange
extends AbstractModelUpdateHandler {
    static final String OPERATION_NAME = "change-file";
    static final HandlerFileChange INSTANCE = new HandlerFileChange();

    protected void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        CommonAttributes.PATH.validateAndSet(operation, model);
        CommonAttributes.RELATIVE_TO.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ServiceTarget serviceTarget = context.getServiceTarget();
        HandlerFileService service = new HandlerFileService(CommonAttributes.PATH.resolveModelAttribute(context, model).asString());
        ServiceBuilder serviceBuilder = serviceTarget.addService(LogServices.handlerName(name), (Service)service);
        ModelNode relativeTo = CommonAttributes.RELATIVE_TO.resolveModelAttribute(context, model);
        if (relativeTo.isDefined()) {
            serviceBuilder.addDependency(AbstractPathService.pathNameOf((String)relativeTo.asString()), String.class, service.getRelativeToInjector());
        }
        context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
        if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
            context.removeService(LogServices.handlerFileName(name));
        }
    }
}

