/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.List;
import java.util.logging.Handler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.AbstractLogHandlerAssignmentHandler;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.LoggerHandlerService;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class LoggerAssignHandler
extends AbstractLogHandlerAssignmentHandler {
    static final String OPERATION_NAME = "assign-handler";
    static final LoggerAssignHandler INSTANCE = new LoggerAssignHandler();

    protected void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        this.updateHandlersForAssign((AttributeDefinition)CommonAttributes.HANDLERS, operation, model);
    }

    @Override
    protected String getHandlerName(ModelNode operation) throws OperationFailedException {
        return CommonAttributes.NAME.validateOperation(operation).asString();
    }

    protected String getLoggerName(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        return address.getLastElement().getValue();
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String loggerName = this.getLoggerName(operation);
        String handlerName = this.getHandlerName(operation);
        ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
        ServiceController loggerHandlerController = serviceRegistry.getService(LogServices.loggerHandlerName(loggerName, handlerName));
        ServiceController handlerController = serviceRegistry.getService(LogServices.handlerName(handlerName));
        if (loggerHandlerController != null) {
            throw LoggerAssignHandler.createFailureMessage(LoggingMessages.MESSAGES.handlerAlreadyDefined(handlerName));
        }
        if (handlerController == null) {
            throw LoggerAssignHandler.createFailureMessage(LoggingMessages.MESSAGES.handlerNotFound(handlerName));
        }
        ServiceTarget target = context.getServiceTarget();
        LoggerHandlerService service = new LoggerHandlerService(loggerName);
        ServiceBuilder builder = target.addService(LogServices.loggerHandlerName(loggerName, handlerName), (Service)service);
        builder.addDependency(LogServices.loggerName(loggerName));
        builder.addDependency(LogServices.handlerName(handlerName), Handler.class, service.getHandlerInjector());
        builder.addListener((ServiceListener)verificationHandler);
        newControllers.add(builder.install());
    }
}

