/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.Target;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class TargetValidator
extends ModelTypeValidator
implements AllowedValuesValidator {
    private final EnumSet<Target> allowedValues = EnumSet.allOf(Target.class);
    private final List<ModelNode> nodeValues = new ArrayList<ModelNode>(this.allowedValues.size());

    public TargetValidator(boolean nullable) {
        super(ModelType.STRING, nullable, false);
        for (Target target : this.allowedValues) {
            this.nodeValues.add(new ModelNode().set(target.toString()));
        }
    }

    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        Target target;
        super.validateParameter(parameterName, value);
        if (value.isDefined() && ((target = Target.fromString(value.asString())) == null || !this.allowedValues.contains((Object)target))) {
            throw new OperationFailedException(new ModelNode().set(LoggingMessages.MESSAGES.invalidTargetName(this.allowedValues)));
        }
    }

    public List<ModelNode> getAllowedValues() {
        return this.nodeValues;
    }
}

