/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb;

import java.util.HashMap;
import java.util.Map;

public enum ORBInitializer {
    UNKNOWN("", ""),
    CODEBASE("codebase", "org.jboss.as.jacorb.codebase.CodebaseInterceptorInitializer"),
    SECURITY("security", "org.jboss.as.jacorb.csiv2.CSIv2Initializer", "org.jboss.as.jacorb.csiv2.SASInitializer"),
    TRANSACTIONS("transaction", "com.arjuna.ats.jts.orbspecific.jacorb.interceptors.interposition.InterpositionORBInitializerImpl", "com.arjuna.ats.jbossatx.jts.InboundTransactionCurrentInitializer", "org.jboss.as.jacorb.tm.TxIORInterceptorInitializer");

    private final String initializerName;
    private final String[] initializerClasses;
    private static final Map<String, ORBInitializer> MAP;

    private ORBInitializer(String initializerName, String ... initializerClasses) {
        this.initializerName = initializerName;
        this.initializerClasses = initializerClasses;
    }

    public String getInitializerName() {
        return this.initializerName;
    }

    public String[] getInitializerClasses() {
        return this.initializerClasses;
    }

    static ORBInitializer forName(String initializerName) {
        ORBInitializer element = MAP.get(initializerName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, ORBInitializer> map = new HashMap<String, ORBInitializer>();
        for (ORBInitializer element : ORBInitializer.values()) {
            String name = element.getInitializerName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

