/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.rmi;

import java.io.Externalizable;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import org.jboss.as.jacorb.rmi.AbstractAnalysis;
import org.jboss.as.jacorb.rmi.AttributeAnalysis;
import org.jboss.as.jacorb.rmi.ContainerAnalysis;
import org.jboss.as.jacorb.rmi.RMIIIOPNotImplementedException;
import org.jboss.as.jacorb.rmi.RMIIIOPViolationException;
import org.jboss.as.jacorb.rmi.ValueMemberAnalysis;
import org.jboss.as.jacorb.rmi.WorkCacheManager;
import org.jboss.logging.Logger;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ValueBase;

public class ValueAnalysis
extends ContainerAnalysis {
    private static final Logger logger = Logger.getLogger(ValueAnalysis.class);
    private static WorkCacheManager cache = new WorkCacheManager(ValueAnalysis.class);
    private ValueAnalysis superAnalysis;
    private boolean abstractValue = false;
    private boolean externalizable = false;
    private boolean hasWriteObjectMethod = false;
    private ObjectStreamField[] serialPersistentFields;
    private ValueMemberAnalysis[] members;

    public static ValueAnalysis getValueAnalysis(Class cls) throws RMIIIOPViolationException {
        return (ValueAnalysis)cache.getAnalysis(cls);
    }

    protected ValueAnalysis(Class cls) {
        super(cls);
        logger.debug((Object)("ValueAnalysis(\"" + cls.getName() + "\") entered."));
    }

    @Override
    public String getIDLModuleName() {
        String result = super.getIDLModuleName();
        Class clazz = this.getCls();
        if (IDLEntity.class.isAssignableFrom(clazz) && !ValueBase.class.isAssignableFrom(clazz)) {
            result = "::org::omg::boxedIDL" + result;
        }
        return result;
    }

    @Override
    protected void doAnalyze() throws RMIIIOPViolationException {
        super.doAnalyze();
        if (this.cls == String.class) {
            throw new IllegalArgumentException("Cannot analyze java.lang.String here: It is a special case.");
        }
        if (this.cls == Class.class) {
            throw new IllegalArgumentException("Cannot analyze java.lang.Class here: It is a special case.");
        }
        if (Remote.class.isAssignableFrom(this.cls)) {
            throw new RMIIIOPViolationException("Value type " + this.cls.getName() + " cannot implement java.rmi.Remote.", "1.2.4");
        }
        if (this.cls.getName().indexOf(36) != -1) {
            throw new RMIIIOPNotImplementedException("Class " + this.cls.getName() + " has a '$', like " + "proxies or inner classes.");
        }
        this.externalizable = Externalizable.class.isAssignableFrom(this.cls);
        if (!this.externalizable) {
            int mods;
            int mods2;
            Field spf = null;
            try {
                spf = this.cls.getField("serialPersistentFields");
            }
            catch (NoSuchFieldException ex) {
                // empty catch block
            }
            if (!(spf == null || Modifier.isFinal(mods2 = spf.getModifiers()) && Modifier.isStatic(mods2) && Modifier.isPrivate(mods2))) {
                spf = null;
            }
            if (spf != null) {
                Class<?> type = spf.getType();
                if (type.isArray()) {
                    if ((type = type.getComponentType()) != ObjectStreamField.class) {
                        spf = null;
                    }
                } else {
                    spf = null;
                }
            }
            if (spf != null) {
                try {
                    this.serialPersistentFields = (ObjectStreamField[])spf.get(null);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException("Unexpected IllegalException: " + ex.toString());
                }
                for (int i = 0; i < this.fields.length; ++i) {
                    if (this.fields[i] != spf) continue;
                    int n = i;
                    this.f_flags[n] = (byte)(this.f_flags[n] | 2);
                    break;
                }
            }
            Method wo = null;
            try {
                wo = this.cls.getMethod("writeObject", OutputStream[].class);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            if (wo != null && wo.getReturnType() != Void.TYPE) {
                wo = null;
            }
            if (wo != null && !Modifier.isPrivate(mods = spf.getModifiers())) {
                wo = null;
            }
            if (wo != null) {
                Class<?>[] paramTypes = wo.getParameterTypes();
                if (paramTypes.length != 1) {
                    wo = null;
                } else if (paramTypes[0] != OutputStream.class) {
                    wo = null;
                }
            }
            if (wo != null) {
                this.hasWriteObjectMethod = true;
                for (int i = 0; i < this.methods.length; ++i) {
                    if (this.methods[i] != wo) continue;
                    int n = i;
                    this.m_flags[n] = (byte)(this.m_flags[n] | 0x20);
                    break;
                }
            }
        }
        TreeSet<ValueMemberAnalysis> m = new TreeSet<ValueMemberAnalysis>(new ValueMemberComparator());
        logger.debug((Object)("ValueAnalysis(\"" + this.cls.getName() + "\"): " + "fields.length=" + this.fields.length));
        for (int i = 0; i < this.fields.length; ++i) {
            logger.debug((Object)("ValueAnalysis(\"" + this.cls.getName() + "\"): " + "Considering field[" + i + "] \"" + this.fields[i].getName() + "\"" + " f_flags=" + this.f_flags[i]));
            if (this.f_flags[i] != 0) continue;
            int mods = this.fields[i].getModifiers();
            logger.debug((Object)("ValueAnalysis(\"" + this.cls.getName() + "\"): mods=" + mods));
            if (Modifier.isStatic(mods) || Modifier.isTransient(mods)) continue;
            ValueMemberAnalysis vma = new ValueMemberAnalysis(this.fields[i].getName(), this.fields[i].getType(), Modifier.isPublic(mods));
            m.add(vma);
        }
        this.members = new ValueMemberAnalysis[m.size()];
        this.members = m.toArray(this.members);
        logger.debug((Object)("ValueAnalysis(\"" + this.cls.getName() + "\") value member count: " + this.members.length));
        Class superClass = this.cls.getSuperclass();
        if (superClass == Object.class) {
            superClass = null;
        }
        if (superClass == null) {
            this.superAnalysis = null;
        } else {
            logger.debug((Object)("ValueAnalysis(\"" + this.cls.getName() + "\"): superclass: " + superClass.getName()));
            this.superAnalysis = ValueAnalysis.getValueAnalysis(superClass);
        }
        if (!Serializable.class.isAssignableFrom(this.cls)) {
            this.abstractValue = true;
        }
        this.fixupCaseNames();
        logger.debug((Object)("ValueAnalysis(\"" + this.cls.getName() + "\") done."));
    }

    public ValueAnalysis getSuperAnalysis() {
        return this.superAnalysis;
    }

    public boolean isAbstractValue() {
        return this.abstractValue;
    }

    public boolean isCustom() {
        return this.externalizable || this.hasWriteObjectMethod;
    }

    public boolean isExternalizable() {
        return this.externalizable;
    }

    public ValueMemberAnalysis[] getMembers() {
        return (ValueMemberAnalysis[])this.members.clone();
    }

    @Override
    protected void analyzeAttributes() throws RMIIIOPViolationException {
        this.attributes = new AttributeAnalysis[0];
    }

    @Override
    protected ArrayList getContainedEntries() {
        int i;
        ArrayList<AbstractAnalysis> ret = new ArrayList<AbstractAnalysis>(this.constants.length + this.attributes.length + this.members.length);
        for (i = 0; i < this.constants.length; ++i) {
            ret.add(this.constants[i]);
        }
        for (i = 0; i < this.attributes.length; ++i) {
            ret.add(this.attributes[i]);
        }
        for (i = 0; i < this.members.length; ++i) {
            ret.add(this.members[i]);
        }
        return ret;
    }

    private static class ValueMemberComparator
    implements Comparator {
        private ValueMemberComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            ValueMemberAnalysis m1 = (ValueMemberAnalysis)o1;
            ValueMemberAnalysis m2 = (ValueMemberAnalysis)o2;
            boolean p1 = m1.getCls().isPrimitive();
            boolean p2 = m2.getCls().isPrimitive();
            if (p1 && !p2) {
                return -1;
            }
            if (!p1 && p2) {
                return 1;
            }
            return m1.getJavaName().compareTo(m2.getJavaName());
        }
    }
}

