/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.io.ByteBuffer;
import org.infinispan.io.ExposedByteArrayOutputStream;
import org.infinispan.marshall.AbstractMarshaller;
import org.infinispan.marshall.jboss.JBossMarshallerFactory;
import org.infinispan.marshall.jboss.SerializeWithExtFactory;
import org.infinispan.util.ConcurrentWeakKeyHashMap;
import org.infinispan.util.logging.BasicLogFactory;
import org.jboss.logging.BasicLogger;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.ExceptionListener;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.TraceInformation;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.reflect.SunReflectiveCreator;

public abstract class AbstractJBossMarshaller
extends AbstractMarshaller {
    protected static final BasicLogger log = BasicLogFactory.getLog(AbstractJBossMarshaller.class);
    protected final MarshallingConfiguration baseCfg;
    protected final MarshallerFactory factory;
    private final ConcurrentMap<Class, Boolean> isMarshallableMap = new ConcurrentWeakKeyHashMap<Class, Boolean>();

    public AbstractJBossMarshaller() {
        this.factory = new JBossMarshallerFactory();
        this.baseCfg = new MarshallingConfiguration();
        this.baseCfg.setCreator((Creator)new SunReflectiveCreator());
        this.baseCfg.setExceptionListener((ExceptionListener)new DebuggingExceptionListener());
        this.baseCfg.setClassExternalizerFactory((ClassExternalizerFactory)new SerializeWithExtFactory());
        this.baseCfg.setVersion(3);
    }

    public void objectToObjectStream(Object obj, ObjectOutput out) throws IOException {
        out.writeObject(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ByteBuffer objectToBuffer(Object o, int estimatedSize) throws IOException {
        ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(estimatedSize);
        ObjectOutput marshaller = this.startObjectOutput((OutputStream)baos, false);
        try {
            this.objectToObjectStream(o, marshaller);
        }
        finally {
            this.finishObjectOutput(marshaller);
        }
        return new ByteBuffer(baos.getRawBuffer(), 0, baos.size());
    }

    public ObjectOutput startObjectOutput(OutputStream os, boolean isReentrant) throws IOException {
        Marshaller marshaller = this.getMarshaller(isReentrant);
        marshaller.start(Marshalling.createByteOutput((OutputStream)os));
        return marshaller;
    }

    protected abstract Marshaller getMarshaller(boolean var1) throws IOException;

    public void finishObjectOutput(ObjectOutput oo) {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Stop marshaller");
            }
            ((Marshaller)oo).finish();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException, ClassNotFoundException {
        ByteArrayInputStream is = new ByteArrayInputStream(buf, offset, length);
        ObjectInput unmarshaller = this.startObjectInput(is, false);
        Object o = null;
        try {
            o = this.objectFromObjectStream(unmarshaller);
        }
        finally {
            this.finishObjectInput(unmarshaller);
        }
        return o;
    }

    public ObjectInput startObjectInput(InputStream is, boolean isReentrant) throws IOException {
        Unmarshaller unmarshaller = this.getUnmarshaller(isReentrant);
        if (log.isTraceEnabled()) {
            log.tracef("Start unmarshaller after retrieving marshaller from %s", (Object)(isReentrant ? "factory" : "thread local"));
        }
        unmarshaller.start(Marshalling.createByteInput((InputStream)is));
        return unmarshaller;
    }

    protected abstract Unmarshaller getUnmarshaller(boolean var1) throws IOException;

    public Object objectFromObjectStream(ObjectInput in) throws IOException, ClassNotFoundException {
        return in.readObject();
    }

    public void finishObjectInput(ObjectInput oi) {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Stop unmarshaller");
            }
            if (oi != null) {
                ((Unmarshaller)oi).finish();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isMarshallable(Object o) throws Exception {
        Class<?> clazz = o.getClass();
        Object isClassMarshallable = this.isMarshallableMap.get(clazz);
        if (isClassMarshallable != null) {
            return (Boolean)isClassMarshallable;
        }
        if (this.isMarshallableCandidate(o)) {
            boolean isMarshallable = true;
            try {
                this.objectToBuffer(o);
            }
            catch (Exception e) {
                isMarshallable = false;
                throw e;
            }
            finally {
                this.isMarshallableMap.putIfAbsent(clazz, isMarshallable);
            }
            return isMarshallable;
        }
        return false;
    }

    public void stop() {
        this.isMarshallableMap.clear();
    }

    protected boolean isMarshallableCandidate(Object o) {
        return o instanceof Serializable;
    }

    protected static class DebuggingExceptionListener
    implements ExceptionListener {
        private static final URL[] EMPTY_URLS = new URL[0];
        private static final Class[] EMPTY_CLASSES = new Class[0];
        private static final Object[] EMPTY_OBJECTS = new Object[0];

        protected DebuggingExceptionListener() {
        }

        public void handleMarshallingException(Throwable problem, Object subject) {
            if (log.isDebugEnabled()) {
                TraceInformation.addUserInformation((Throwable)problem, (Serializable)((Object)("toString = " + subject.toString())));
            }
        }

        public void handleUnmarshallingException(Throwable problem, Class<?> subjectClass) {
            if (log.isDebugEnabled()) {
                StringBuilder builder = new StringBuilder();
                ClassLoader cl = subjectClass.getClassLoader();
                builder.append("classloader hierarchy:");
                for (ClassLoader parent = cl; parent != null; parent = parent.getParent()) {
                    if (parent.equals(cl)) {
                        builder.append("\n\t\t-> type classloader = ").append(parent);
                    } else {
                        builder.append("\n\t\t-> parent classloader = ").append(parent);
                    }
                    URL[] urls = DebuggingExceptionListener.getClassLoaderURLs(parent);
                    if (urls == null) continue;
                    for (URL u : urls) {
                        builder.append("\n\t\t->...").append(u);
                    }
                }
                TraceInformation.addUserInformation((Throwable)problem, (Serializable)((Object)builder.toString()));
            }
        }

        public void handleUnmarshallingException(Throwable problem) {
        }

        private static URL[] getClassLoaderURLs(ClassLoader cl) {
            URL[] urls = EMPTY_URLS;
            try {
                Class<?> returnType = urls.getClass();
                Class[] parameterTypes = EMPTY_CLASSES;
                Method getURLs = cl.getClass().getMethod("getURLs", parameterTypes);
                if (returnType.isAssignableFrom(getURLs.getReturnType())) {
                    Object[] args = EMPTY_OBJECTS;
                    urls = (URL[])getURLs.invoke((Object)cl, args);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return urls;
        }
    }
}

