/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Service;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.jaxrpc.client.ServiceExt;
import org.jboss.ws.core.jaxrpc.client.ServiceImpl;

public class ServiceProxy
implements InvocationHandler {
    private static final ResourceBundle bundle = BundleUtils.getBundle(ServiceProxy.class);
    private static final Logger log = Logger.getLogger(ServiceProxy.class);
    private ServiceImpl jaxrpcService;
    private List objectMethods = new ArrayList();
    private List jaxrpcServiceMethods = new ArrayList();
    private List serviceInterfaceMethods = new ArrayList();
    private Method getPortMethod;

    public ServiceProxy(ServiceImpl service, Class siClass) {
        this.jaxrpcService = service;
        this.objectMethods.addAll(Arrays.asList(Object.class.getMethods()));
        this.jaxrpcServiceMethods.addAll(Arrays.asList(ServiceExt.class.getMethods()));
        if (!siClass.getName().equals("javax.xml.rpc.Service")) {
            this.serviceInterfaceMethods.addAll(Arrays.asList(siClass.getDeclaredMethods()));
        }
        try {
            this.getPortMethod = Service.class.getMethod("getPort", Class.class);
        }
        catch (NoSuchMethodException e) {
            throw new JAXRPCException(e.toString());
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        try {
            Object retObj = null;
            if (this.jaxrpcServiceMethods.contains(method)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invoke on jaxrpc service: " + methodName));
                }
                if (method.getName().equals("getPort")) {
                    Remote port = (Remote)method.invoke((Object)this.jaxrpcService, args);
                    return port;
                }
                retObj = method.invoke((Object)this.jaxrpcService, args);
                return retObj;
            }
            if (this.serviceInterfaceMethods.contains(method)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invoke on service interface: " + methodName));
                }
                Class<?> seiClass = method.getReturnType();
                retObj = this.getPortMethod.invoke((Object)this.jaxrpcService, seiClass);
                return retObj;
            }
            if (this.objectMethods.contains(method)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invoke on object: " + methodName));
                }
                retObj = method.invoke((Object)this.jaxrpcService, args);
                return retObj;
            }
            throw new JAXRPCException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NOT_KNOW_HOW_TO_INVOKE", (Object[])new Object[]{method}));
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    private void handleException(Exception ex) throws Throwable {
        Throwable th = ex;
        if (ex instanceof InvocationTargetException) {
            th = ((InvocationTargetException)ex).getTargetException();
        }
        log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"SERVICE_ERROR", (Object[])new Object[0]), th);
        throw th;
    }
}

