/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.control;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.TransactionalInvocationContextFlagsOverride;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class LockControlCommand
extends AbstractTransactionBoundaryCommand
implements FlagAffectedCommand {
    private static final Log log = LogFactory.getLog(LockControlCommand.class);
    public static final int COMMAND_ID = 3;
    private List<Object> keys;
    private boolean unlock = false;
    private Set<Flag> flags;

    private LockControlCommand() {
        super(null);
    }

    public LockControlCommand(String cacheName) {
        super(cacheName);
    }

    public LockControlCommand(Collection<Object> keys, String cacheName, Set<Flag> flags, GlobalTransaction gtx) {
        super(cacheName);
        this.keys = keys != null ? new ArrayList<Object>(keys) : Collections.emptyList();
        this.flags = flags;
        this.globalTx = gtx;
    }

    public LockControlCommand(Object key, String cacheName, Set<Flag> flags, GlobalTransaction gtx) {
        this(cacheName);
        this.keys = new ArrayList<Object>();
        this.keys.add(key);
        this.flags = flags;
        this.globalTx = gtx;
    }

    public void setGlobalTransaction(GlobalTransaction gtx) {
        this.globalTx = gtx;
    }

    public Collection<Object> getKeys() {
        return this.keys;
    }

    public void replaceKey(Object oldKey, Object replacement) {
        int i = this.keys.indexOf(oldKey);
        if (i >= 0) {
            this.keys.set(i, replacement);
        }
    }

    public void replaceKeys(Map<Object, Object> replacements) {
        for (int i = 0; i < this.keys.size(); ++i) {
            Object replacement = replacements.get(this.keys.get(i));
            if (replacement == null) continue;
            this.keys.set(i, replacement);
        }
    }

    public boolean multipleKeys() {
        return this.keys.size() > 1;
    }

    public Object getSingleKey() {
        if (this.keys.size() == 0) {
            return null;
        }
        return this.keys.get(0);
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitLockControlCommand((TxInvocationContext)ctx, this);
    }

    @Override
    public Object perform(InvocationContext ignored) throws Throwable {
        if (ignored != null) {
            throw new IllegalStateException("Expected null context!");
        }
        RemoteTxInvocationContext ctxt = this.icc.createRemoteTxInvocationContext(this.getOrigin());
        RemoteTransaction transaction = this.txTable.getRemoteTransaction(this.globalTx);
        if (transaction == null) {
            if (this.unlock) {
                if (log.isTraceEnabled()) {
                    log.tracef("Unlock for non-existant transaction %s.  Not doing anything.", this.globalTx);
                }
                return null;
            }
            transaction = this.txTable.createRemoteTransaction(this.globalTx, null);
        }
        ctxt.setRemoteTransaction(transaction);
        TxInvocationContext ctx = ctxt;
        if (this.flags != null && !this.flags.isEmpty()) {
            ctx = new TransactionalInvocationContextFlagsOverride(ctxt, this.flags);
        }
        return this.invoker.invoke(ctx, this);
    }

    @Override
    public byte getCommandId() {
        return 3;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.globalTx, this.unlock, this.keys, this.flags};
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        if (commandId != 3) {
            throw new IllegalStateException("Unsupported command id:" + commandId);
        }
        int i = 0;
        this.globalTx = (GlobalTransaction)args[i++];
        this.unlock = (Boolean)args[i++];
        this.keys = (List)args[i++];
        this.flags = (Set)args[i];
    }

    public boolean isUnlock() {
        return this.unlock;
    }

    public void setUnlock(boolean unlock) {
        this.unlock = unlock;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LockControlCommand that = (LockControlCommand)o;
        if (this.unlock != that.unlock) {
            return false;
        }
        if (this.flags == null) {
            return that.flags == null;
        }
        if (!((Object)this.flags).equals(that.flags)) {
            return false;
        }
        return ((Object)this.keys).equals(that.keys);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ((Object)this.keys).hashCode();
        result = 31 * result + (this.unlock ? 1 : 0);
        if (this.flags != null) {
            result = 31 * result + ((Object)this.flags).hashCode();
        }
        return result;
    }

    @Override
    public String toString() {
        return "LockControlCommand{cache=" + this.cacheName + ", keys=" + this.keys + ", flags=" + this.flags + ", unlock=" + this.unlock + "}";
    }

    @Override
    public Set<Flag> getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(Set<Flag> flags) {
        this.flags = flags;
    }
}

