/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.configuration.cache.AbstractClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.L1Configuration;

public class L1ConfigurationBuilder
extends AbstractClusteringConfigurationChildBuilder<L1Configuration> {
    private boolean enabled = true;
    private int invalidationThreshold = 0;
    private long lifespan = 600000L;
    private boolean onRehash = true;

    L1ConfigurationBuilder(ClusteringConfigurationBuilder builder) {
        super(builder);
    }

    public L1ConfigurationBuilder invalidationThreshold(int invalidationThreshold) {
        this.invalidationThreshold = invalidationThreshold;
        return this;
    }

    public L1ConfigurationBuilder lifespan(long livespan) {
        this.lifespan = livespan;
        return this;
    }

    public L1ConfigurationBuilder enableOnRehash() {
        this.onRehash = true;
        return this;
    }

    public L1ConfigurationBuilder disableOnRehash() {
        this.onRehash = false;
        return this;
    }

    public L1ConfigurationBuilder enable() {
        this.enabled = true;
        return this;
    }

    public L1ConfigurationBuilder disable() {
        this.enabled = false;
        return this;
    }

    public L1ConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    void validate() {
    }

    @Override
    L1Configuration create() {
        return new L1Configuration(this.enabled, this.invalidationThreshold, this.lifespan, this.onRehash);
    }
}

