/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.LinkedList;
import java.util.List;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LoaderConfiguration;
import org.infinispan.configuration.cache.LoaderConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfiguration;

public class LoadersConfigurationBuilder
extends AbstractConfigurationChildBuilder<LoadersConfiguration> {
    private boolean passivation;
    private boolean preload;
    private boolean shared;
    private List<LoaderConfigurationBuilder> cacheLoaders;

    protected LoadersConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public LoadersConfigurationBuilder passivation(boolean b) {
        this.passivation = b;
        return this;
    }

    public LoadersConfigurationBuilder preload(boolean b) {
        this.preload = b;
        return this;
    }

    public LoadersConfigurationBuilder shared(boolean b) {
        this.shared = b;
        return this;
    }

    public LoaderConfigurationBuilder addCacheLoader() {
        LoaderConfigurationBuilder builder = new LoaderConfigurationBuilder(this);
        this.cacheLoaders.add(builder);
        return builder;
    }

    @Override
    void validate() {
    }

    @Override
    LoadersConfiguration create() {
        LinkedList<LoaderConfiguration> loaders = new LinkedList<LoaderConfiguration>();
        for (LoaderConfigurationBuilder loader : this.cacheLoaders) {
            loaders.add(loader.create());
        }
        return new LoadersConfiguration(this.passivation, this.preload, this.shared, loaders);
    }
}

