/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Set;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.commands.RemoteCommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.read.DistributedExecuteCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;

public class ReplicableCommandExternalizer
extends AbstractExternalizer<ReplicableCommand> {
    RemoteCommandsFactory cmdFactory;
    private GlobalComponentRegistry globalComponentRegistry;

    public void inject(RemoteCommandsFactory cmdFactory, GlobalComponentRegistry globalComponentRegistry) {
        this.cmdFactory = cmdFactory;
        this.globalComponentRegistry = globalComponentRegistry;
    }

    public void writeObject(ObjectOutput output, ReplicableCommand command) throws IOException {
        this.writeCommandHeader(output, command);
        this.writeCommandParameters(output, command);
    }

    protected void writeCommandParameters(ObjectOutput output, ReplicableCommand command) throws IOException {
        Object[] args = command.getParameters();
        int numArgs = args == null ? 0 : args.length;
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)numArgs);
        for (int i = 0; i < numArgs; ++i) {
            Object arg = args[i];
            if (arg instanceof DeltaAware) {
                DeltaAware dw = (DeltaAware)arg;
                output.writeObject(dw.delta());
                continue;
            }
            output.writeObject(arg);
        }
    }

    protected void writeCommandHeader(ObjectOutput output, ReplicableCommand command) throws IOException {
        Collection<Class<? extends ReplicableCommand>> moduleCommands = this.getModuleCommands();
        if (moduleCommands.contains(command.getClass())) {
            output.writeByte(1);
        } else {
            output.writeByte(0);
        }
        output.writeShort(command.getCommandId());
    }

    public ReplicableCommand readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        byte type = input.readByte();
        short methodId = input.readShort();
        Object[] args = this.readParameters(input);
        return this.cmdFactory.fromStream((byte)methodId, args, type);
    }

    protected Object[] readParameters(ObjectInput input) throws IOException, ClassNotFoundException {
        int numArgs = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        Object[] args = null;
        if (numArgs > 0) {
            args = new Object[numArgs];
            for (int i = 0; i < numArgs; ++i) {
                args[i] = input.readObject();
            }
        }
        return args;
    }

    public Integer getId() {
        return 62;
    }

    public Set<Class<? extends ReplicableCommand>> getTypeClasses() {
        Set coreCommands = Util.asSet((Object[])new Class[]{DistributedExecuteCommand.class, GetKeyValueCommand.class, ClearCommand.class, EvictCommand.class, ApplyDeltaCommand.class, InvalidateCommand.class, InvalidateL1Command.class, PutKeyValueCommand.class, PutMapCommand.class, RemoveCommand.class, ReplaceCommand.class});
        Collection<Class<? extends ReplicableCommand>> moduleCommands = this.globalComponentRegistry.getModuleProperties().moduleOnlyReplicableCommands();
        if (moduleCommands != null && !moduleCommands.isEmpty()) {
            coreCommands.addAll(moduleCommands);
        }
        return coreCommands;
    }

    private Collection<Class<? extends ReplicableCommand>> getModuleCommands() {
        return this.globalComponentRegistry.getModuleProperties().moduleCommands(null);
    }
}

