/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss;

import java.io.IOException;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.marshall.jboss.AbstractJBossMarshaller;
import org.infinispan.marshall.jboss.DefaultContextClassResolver;
import org.infinispan.marshall.jboss.ExternalizerTable;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;

public class JBossMarshaller
extends AbstractJBossMarshaller
implements StreamingMarshaller {
    private InvocationContextContainer icc;
    ExternalizerTable externalizerTable;

    public void inject(ExternalizerTable externalizerTable, ClassLoader cl, InvocationContextContainer icc) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Using JBoss Marshalling");
        }
        this.icc = icc;
        this.externalizerTable = externalizerTable;
        this.baseCfg.setObjectTable((ObjectTable)externalizerTable);
        this.baseCfg.setClassResolver((ClassResolver)new EmbeddedContextClassResolver(cl));
    }

    protected Marshaller getMarshaller(boolean isReentrant) throws IOException {
        return this.factory.createMarshaller(this.baseCfg);
    }

    protected Unmarshaller getUnmarshaller(boolean isReentrant) throws IOException {
        return this.factory.createUnmarshaller(this.baseCfg);
    }

    public void stop() {
        super.stop();
        this.baseCfg.setClassResolver(null);
    }

    public boolean isMarshallableCandidate(Object o) {
        return super.isMarshallableCandidate(o) || this.externalizerTable.isMarshallableCandidate(o);
    }

    public class EmbeddedContextClassResolver
    extends DefaultContextClassResolver {
        public EmbeddedContextClassResolver(ClassLoader defaultClassLoader) {
            super(defaultClassLoader);
        }

        protected ClassLoader getClassLoader() {
            ClassLoader cl;
            InvocationContext ctx;
            if (JBossMarshaller.this.icc != null && (ctx = JBossMarshaller.this.icc.getInvocationContext(true)) != null && (cl = ctx.getClassLoader()) != null) {
                return cl;
            }
            return super.getClassLoader();
        }
    }
}

