/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.infinispan.CacheException;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.xa.LocalXaTransaction;
import org.infinispan.transaction.xa.TransactionXaAdapter;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class XaTransactionTable
extends TransactionTable {
    private static final Log log = LogFactory.getLog(XaTransactionTable.class);
    protected final ConcurrentMap<Xid, LocalXaTransaction> xid2LocalTx = new ConcurrentHashMap<Xid, LocalXaTransaction>();
    private RecoveryManager recoveryManager;

    @Inject
    public void init(RecoveryManager recoveryManager) {
        this.recoveryManager = recoveryManager;
    }

    @Override
    public boolean removeLocalTransaction(LocalTransaction localTx) {
        boolean result = false;
        if (localTx.getTransaction() != null) {
            result = super.removeLocalTransaction(localTx);
        }
        this.removeXidTxMapping((LocalXaTransaction)localTx);
        return result;
    }

    private void removeXidTxMapping(LocalXaTransaction localTx) {
        Xid xid = localTx.getXid();
        this.xid2LocalTx.remove(xid);
    }

    @Override
    public LocalTransaction removeLocalTransaction(Transaction tx) {
        LocalTransaction remove = this.removeLocalTransactionInternal(tx);
        if (remove != null) {
            this.removeXidTxMapping((LocalXaTransaction)remove);
        }
        return remove;
    }

    public LocalXaTransaction getLocalTransaction(Xid xid) {
        return (LocalXaTransaction)this.xid2LocalTx.get(xid);
    }

    public void addLocalTransactionMapping(LocalXaTransaction localTransaction) {
        if (localTransaction.getXid() == null) {
            throw new IllegalStateException("Initialize xid first!");
        }
        this.xid2LocalTx.put(localTransaction.getXid(), localTransaction);
    }

    @Override
    public void enlist(Transaction transaction, LocalTransaction ltx) {
        LocalXaTransaction localTransaction = (LocalXaTransaction)ltx;
        if (!localTransaction.isEnlisted()) {
            try {
                transaction.enlistResource((XAResource)new TransactionXaAdapter(localTransaction, this, this.configuration, this.recoveryManager, this.txCoordinator, this.commandsFactory, this.rpcManager, this.clusteringLogic, this.configuration));
            }
            catch (Exception e) {
                Xid xid = localTransaction.getXid();
                if (xid != null && !localTransaction.getLookedUpEntries().isEmpty()) {
                    log.debug("Attempting a rollback to clear stale resources!");
                    try {
                        this.txCoordinator.rollback(localTransaction);
                    }
                    catch (XAException xae) {
                        log.debug("Caught exception attempting to clean up " + xid, xae);
                    }
                }
                log.error("Failed to enlist TransactionXaAdapter to transaction", e);
                throw new CacheException((Throwable)e);
            }
        }
    }

    public RecoveryManager getRecoveryManager() {
        return this.recoveryManager;
    }

    public void setRecoveryManager(RecoveryManager recoveryManager) {
        this.recoveryManager = recoveryManager;
    }

    @Override
    public int getLocalTxCount() {
        return this.xid2LocalTx.size();
    }
}

