/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.deployment;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ApplicationPath;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.jaxrs.JaxrsLogger;
import org.jboss.as.jaxrs.deployment.JaxrsAttachments;
import org.jboss.as.jaxrs.deployment.JaxrsDeploymentMarker;
import org.jboss.as.jaxrs.deployment.ResteasyDeploymentData;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.modules.Module;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;

public class JaxrsIntegrationProcessor
implements DeploymentUnitProcessor {
    private static final String JAX_RS_SERVLET_NAME = "javax.ws.rs.core.Application";
    private static final String SERVLET_INIT_PARAM = "javax.ws.rs.Application";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        List mappings;
        String servletName;
        String providers;
        StringBuffer buf;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (!JaxrsDeploymentMarker.isJaxrsDeployment(deploymentUnit)) {
            return;
        }
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        DeploymentUnit parent = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        JBossWebMetaData webdata = warMetaData.getMergedJBossWebMetaData();
        ResteasyDeploymentData resteasy = (ResteasyDeploymentData)deploymentUnit.getAttachment(JaxrsAttachments.RESTEASY_DEPLOYMENT_DATA);
        if (resteasy == null) {
            return;
        }
        List params = webdata.getContextParams();
        if (params != null) {
            Iterator it = params.iterator();
            while (it.hasNext()) {
                ParamValueMetaData param = (ParamValueMetaData)it.next();
                if (!param.getParamName().equals("resteasy.scan")) continue;
                it.remove();
                JaxrsLogger.JAXRS_LOGGER.resteasyScanWarning();
            }
        }
        Map attachmentMap = (Map)parent.getAttachment(JaxrsAttachments.ADDITIONAL_RESTEASY_DEPLOYMENT_DATA);
        ArrayList<ResteasyDeploymentData> additionalData = new ArrayList<ResteasyDeploymentData>();
        ModuleSpecification moduleSpec = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        if (moduleSpec != null && attachmentMap != null) {
            for (ModuleDependency dep : moduleSpec.getAllDependencies()) {
                if (!attachmentMap.containsKey(dep.getIdentifier())) continue;
                additionalData.add((ResteasyDeploymentData)attachmentMap.get(dep.getIdentifier()));
            }
            resteasy.merge(additionalData);
        }
        if (!resteasy.getScannedResourceClasses().isEmpty()) {
            buf = null;
            for (String resource : resteasy.getScannedResourceClasses()) {
                if (buf == null) {
                    buf = new StringBuffer();
                    buf.append(resource);
                    continue;
                }
                buf.append(",").append(resource);
            }
            String resources = buf.toString();
            JaxrsLogger.JAXRS_LOGGER.debugf("Adding JAX-RS resource classes: %s", resources);
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.scanned.resources", resources);
        }
        if (!resteasy.getScannedProviderClasses().isEmpty()) {
            buf = null;
            for (String provider : resteasy.getScannedProviderClasses()) {
                if (buf == null) {
                    buf = new StringBuffer();
                    buf.append(provider);
                    continue;
                }
                buf.append(",").append(provider);
            }
            providers = buf.toString();
            JaxrsLogger.JAXRS_LOGGER.debugf("Adding JAX-RS provider classes: %s", providers);
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.scanned.providers", providers);
        }
        if (!resteasy.getScannedJndiComponentResources().isEmpty()) {
            buf = null;
            for (String resource : resteasy.getScannedJndiComponentResources()) {
                if (buf == null) {
                    buf = new StringBuffer();
                    buf.append(resource);
                    continue;
                }
                buf.append(",").append(resource);
            }
            providers = buf.toString();
            JaxrsLogger.JAXRS_LOGGER.debugf("Adding JAX-RS jndi component resource classes: %s", providers);
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.scanned.jndi.resources", providers);
        }
        if (!resteasy.isUnwrappedExceptionsParameterSet()) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.unwrapped.exceptions", "javax.ejb.EJBException");
        }
        if (resteasy.hasBootClasses() || resteasy.isDispatcherCreated()) {
            return;
        }
        if (resteasy.getScannedApplicationClass() == null && resteasy.getScannedJndiComponentResources().isEmpty() && resteasy.getScannedProviderClasses().isEmpty() && resteasy.getScannedResourceClasses().isEmpty()) {
            return;
        }
        boolean useScannedClass = false;
        if (resteasy.getScannedApplicationClass() == null) {
            JBossServletMetaData servlet = new JBossServletMetaData();
            servlet.setName(JAX_RS_SERVLET_NAME);
            servlet.setServletClass(HttpServlet30Dispatcher.class.getName());
            servlet.setAsyncSupported(true);
            this.addServlet(webdata, servlet);
            servletName = JAX_RS_SERVLET_NAME;
        } else {
            ParamValueMetaData param = JaxrsIntegrationProcessor.findInitParam(webdata, SERVLET_INIT_PARAM);
            if (param != null) {
                servletName = param.getParamValue();
                JaxrsIntegrationProcessor.setContextParameter(webdata, SERVLET_INIT_PARAM, servletName);
            } else {
                ParamValueMetaData contextParam = JaxrsIntegrationProcessor.findContextParam(webdata, SERVLET_INIT_PARAM);
                if (contextParam == null) {
                    JaxrsIntegrationProcessor.setContextParameter(webdata, SERVLET_INIT_PARAM, resteasy.getScannedApplicationClass().getName());
                    useScannedClass = true;
                    servletName = resteasy.getScannedApplicationClass().getName();
                } else {
                    servletName = contextParam.getParamValue();
                }
            }
        }
        boolean mappingSet = false;
        if (useScannedClass) {
            if (!JaxrsIntegrationProcessor.servletMappingsExist(webdata, servletName)) {
                String pathValue;
                ArrayList<String> patterns = new ArrayList<String>();
                if (resteasy.getScannedApplicationClass().isAnnotationPresent(ApplicationPath.class)) {
                    ApplicationPath path = resteasy.getScannedApplicationClass().getAnnotation(ApplicationPath.class);
                    pathValue = path.value().trim();
                    if (!pathValue.startsWith("/")) {
                        pathValue = "/" + pathValue;
                    }
                } else {
                    JaxrsLogger.JAXRS_LOGGER.noServletMappingFound(servletName);
                    return;
                }
                String prefix = pathValue;
                pathValue = pathValue.endsWith("/") ? pathValue + "*" : pathValue + "/*";
                patterns.add(pathValue);
                JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.servlet.mapping.prefix", prefix);
                mappingSet = true;
                ServletMappingMetaData mapping = new ServletMappingMetaData();
                mapping.setServletName(servletName);
                mapping.setUrlPatterns(patterns);
                if (webdata.getServletMappings() == null) {
                    webdata.setServletMappings(new ArrayList());
                }
                webdata.getServletMappings().add(mapping);
            }
            JBossServletMetaData servlet = new JBossServletMetaData();
            servlet.setName(servletName);
            servlet.setServletClass(HttpServlet30Dispatcher.class.getName());
            servlet.setAsyncSupported(true);
            this.addServlet(webdata, servlet);
        }
        if (!mappingSet && (mappings = webdata.getServletMappings()) != null) {
            for (ServletMappingMetaData mapping : mappings) {
                if (!mapping.getServletName().equals(servletName) || mapping.getUrlPatterns() == null) continue;
                for (String pattern : mapping.getUrlPatterns()) {
                    if (mappingSet) {
                        JaxrsLogger.JAXRS_LOGGER.moreThanOneServletMapping(servletName, pattern);
                        continue;
                    }
                    mappingSet = true;
                    String realPattern = pattern;
                    if (realPattern.endsWith("*")) {
                        realPattern = realPattern.substring(0, realPattern.length() - 1);
                    }
                    JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.servlet.mapping.prefix", realPattern);
                }
            }
        }
    }

    private void addServlet(JBossWebMetaData webdata, JBossServletMetaData servlet) {
        if (webdata.getServlets() == null) {
            webdata.setServlets(new JBossServletsMetaData());
        }
        webdata.getServlets().add((MappableMetaData)servlet);
    }

    public void undeploy(DeploymentUnit context) {
    }

    protected void setFilterInitParam(FilterMetaData filter, String name, String value) {
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(name);
        param.setParamValue(value);
        ArrayList<ParamValueMetaData> params = filter.getInitParam();
        if (params == null) {
            params = new ArrayList<ParamValueMetaData>();
            filter.setInitParam(params);
        }
        params.add(param);
    }

    public static ParamValueMetaData findContextParam(JBossWebMetaData webdata, String name) {
        List params = webdata.getContextParams();
        if (params == null) {
            return null;
        }
        for (ParamValueMetaData param : params) {
            if (!param.getParamName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public static ParamValueMetaData findInitParam(JBossWebMetaData webdata, String name) {
        JBossServletsMetaData servlets = webdata.getServlets();
        if (servlets == null) {
            return null;
        }
        for (JBossServletMetaData servlet : servlets) {
            List initParams = servlet.getInitParam();
            if (initParams == null) continue;
            for (ParamValueMetaData param : initParams) {
                if (!param.getParamName().equals(name)) continue;
                return param;
            }
        }
        return null;
    }

    public static boolean servletMappingsExist(JBossWebMetaData webdata, String servletName) {
        List mappings = webdata.getServletMappings();
        if (mappings == null) {
            return false;
        }
        for (ServletMappingMetaData mapping : mappings) {
            if (!mapping.getServletName().equals(servletName)) continue;
            return true;
        }
        return false;
    }

    public static void setContextParameter(JBossWebMetaData webdata, String name, String value) {
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(name);
        param.setParamValue(value);
        ArrayList<ParamValueMetaData> params = webdata.getContextParams();
        if (params == null) {
            params = new ArrayList<ParamValueMetaData>();
            webdata.setContextParams(params);
        }
        params.add(param);
    }
}

