/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.RaOperationUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public class RaRemove
extends RaOperationUtil
implements OperationStepHandler {
    static final RaRemove INSTANCE = new RaRemove();

    public void execute(OperationContext context, ModelNode operation) {
        ModelNode opAddr = operation.require("address");
        String archive = PathAddress.pathAddress((ModelNode)opAddr).getLastElement().getValue();
        operation.get(Constants.ARCHIVE.getName()).set(archive);
        ModelNode model = context.readModel(PathAddress.EMPTY_ADDRESS);
        ModelNode compensating = Util.getEmptyOperation((String)"add", (ModelNode)opAddr);
        if (model.hasDefined("resource-adapters")) {
            for (ModelNode raNode : model.get("resource-adapters").asList()) {
                ModelNode raCompensatingNode = raNode.clone();
                compensating.get("resource-adapters").add(raCompensatingNode);
            }
        }
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) {
                context.removeService(ConnectorServices.RESOURCEADAPTERS_SERVICE);
                if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                    // empty if block
                }
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep();
    }
}

