/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.entity;

import java.lang.reflect.Method;
import java.util.Map;
import javax.ejb.EJBException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.ViewInstanceFactory;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentInstance;
import org.jboss.as.ejb3.component.entity.interceptors.EntityBeanHomeCreateInterceptorFactory;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EntityEJBLocator;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class EntityBeanRemoteViewInstanceFactory
implements ViewInstanceFactory {
    private final String applicationName;
    private final String moduleName;
    private final String distinctName;
    private final String beanName;

    public EntityBeanRemoteViewInstanceFactory(String applicationName, String moduleName, String distinctName, String beanName) {
        this.applicationName = applicationName;
        this.moduleName = moduleName;
        this.distinctName = distinctName;
        this.beanName = beanName;
    }

    public ManagedReference createViewInstance(ComponentView componentView, Map<Object, Object> contextData) {
        Object primaryKey = contextData.get(EntityBeanComponent.PRIMARY_KEY_CONTEXT_KEY);
        if (primaryKey == null) {
            primaryKey = this.invokeCreate(componentView.getComponent(), contextData);
        }
        Object value = EJBClient.createProxy((EJBLocator)new EntityEJBLocator(componentView.getViewClass(), this.applicationName, this.moduleName, this.beanName, this.distinctName, primaryKey));
        return new ValueManagedReference((Value)new ImmediateValue(value));
    }

    private Object invokeCreate(Component component, Map<Object, Object> contextData) {
        Object primaryKey;
        Method ejbCreate = (Method)contextData.get(EntityBeanHomeCreateInterceptorFactory.EJB_CREATE_METHOD_KEY);
        if (ejbCreate == null) {
            throw new IllegalStateException("Entities can not be created.  No create method available.");
        }
        Method ejbPostCreate = (Method)contextData.get(EntityBeanHomeCreateInterceptorFactory.EJB_POST_CREATE_METHOD_KEY);
        Object[] params = (Object[])contextData.get(EntityBeanHomeCreateInterceptorFactory.PARAMETERS_KEY);
        if (!(component instanceof EntityBeanComponent)) {
            throw new IllegalStateException("Unexpected component: " + component + " Expected " + EntityBeanComponent.class);
        }
        final EntityBeanComponent entityBeanComponent = (EntityBeanComponent)component;
        final EntityBeanComponentInstance instance = entityBeanComponent.getPool().get();
        try {
            primaryKey = this.invokeEjbCreate(contextData, ejbCreate, instance, params);
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        instance.associate(primaryKey);
        entityBeanComponent.getCache().create(instance);
        try {
            this.invokeEjbPostCreate(contextData, ejbPostCreate, instance, params);
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        TransactionSynchronizationRegistry transactionSynchronizationRegistry = entityBeanComponent.getTransactionSynchronizationRegistry();
        if (transactionSynchronizationRegistry.getTransactionKey() != null) {
            transactionSynchronizationRegistry.registerInterposedSynchronization(new Synchronization(){

                public void beforeCompletion() {
                }

                public void afterCompletion(int status) {
                    if (status != 3) {
                        entityBeanComponent.getPool().release(instance);
                    }
                }
            });
        }
        return primaryKey;
    }

    protected void invokeEjbPostCreate(Map<Object, Object> contextData, Method ejbPostCreate, EntityBeanComponentInstance instance, Object[] params) throws Exception {
        ejbPostCreate.invoke((Object)instance.getInstance(), params);
    }

    protected Object invokeEjbCreate(Map<Object, Object> contextData, Method ejbCreate, EntityBeanComponentInstance instance, Object[] params) throws Exception {
        return ejbCreate.invoke((Object)instance.getInstance(), params);
    }
}

