/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.entity.interceptors;

import java.rmi.RemoteException;
import javax.ejb.ConcurrentAccessException;
import javax.ejb.ConcurrentAccessTimeoutException;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentInstance;
import org.jboss.as.ejb3.component.interceptors.AbstractEJBInterceptor;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public class EntityBeanAssociatingInterceptorFactory
implements InterceptorFactory {
    public static final EntityBeanAssociatingInterceptorFactory INSTANCE = new EntityBeanAssociatingInterceptorFactory();

    private EntityBeanAssociatingInterceptorFactory() {
    }

    public Interceptor create(InterceptorFactoryContext factoryContext) {
        return new AbstractEJBInterceptor(){

            public Object processInvocation(InterceptorContext context) throws Exception {
                EntityBeanComponent component = 1.getComponent(context, EntityBeanComponent.class);
                Object primaryKey = context.getPrivateData(EntityBeanComponent.PRIMARY_KEY_CONTEXT_KEY);
                if (primaryKey == null) {
                    throw EjbMessages.MESSAGES.primaryKeyIsNull();
                }
                EntityBeanComponentInstance instance = component.getCache().get(primaryKey);
                if (instance.isRemoved()) {
                    throw EjbMessages.MESSAGES.instaceWasRemoved(component.getComponentName(), primaryKey);
                }
                try {
                    context.putPrivateData(ComponentInstance.class, (Object)instance);
                    Object object = context.proceed();
                    return object;
                }
                catch (Exception ex) {
                    if (component.getApplicationException(ex.getClass(), context.getMethod()) != null) {
                        throw ex;
                    }
                    if (ex instanceof ConcurrentAccessTimeoutException || ex instanceof ConcurrentAccessException) {
                        throw ex;
                    }
                    if (ex instanceof RuntimeException || ex instanceof RemoteException) {
                        if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                            EjbLogger.ROOT_LOGGER.trace("Discarding bean " + primaryKey + " because of exception", ex);
                        }
                        component.getCache().discard(instance);
                    }
                    throw ex;
                }
                catch (Error e) {
                    if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                        EjbLogger.ROOT_LOGGER.trace("Discarding bean " + primaryKey + " because of error", e);
                    }
                    component.getCache().discard(instance);
                    throw e;
                }
                catch (Throwable t) {
                    if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                        EjbLogger.ROOT_LOGGER.trace("Discarding bean " + primaryKey + " because of Throwable", t);
                    }
                    component.getCache().discard(instance);
                    throw new RuntimeException(t);
                }
                finally {
                    context.putPrivateData(ComponentInstance.class, null);
                }
            }
        };
    }
}

