/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.TimerService;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.cache.Cache;
import org.jboss.as.ejb3.cache.ExpiringCache;
import org.jboss.as.ejb3.cache.StatefulObjectFactory;
import org.jboss.as.ejb3.component.DefaultAccessTimeoutService;
import org.jboss.as.ejb3.component.EJBBusinessMethod;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentCreateService;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.ejb3.concurrency.AccessTimeoutDetails;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.SimpleInterceptorFactoryContext;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StopContext;

public class StatefulSessionComponent
extends SessionBeanComponent {
    public static final Object SESSION_ID_REFERENCE_KEY = new Object();
    private static final Logger logger = Logger.getLogger(StatefulSessionComponent.class);
    private final Cache<StatefulSessionComponentInstance> cache;
    private final InterceptorFactory afterBegin;
    private final Method afterBeginMethod;
    private final InterceptorFactory afterCompletion;
    private final Method afterCompletionMethod;
    private final InterceptorFactory beforeCompletion;
    private final Method beforeCompletionMethod;
    private final Map<EJBBusinessMethod, AccessTimeoutDetails> methodAccessTimeouts;
    private final DefaultAccessTimeoutService defaultAccessTimeoutProvider;

    protected StatefulSessionComponent(StatefulSessionComponentCreateService ejbComponentCreateService) {
        super(ejbComponentCreateService);
        this.afterBegin = ejbComponentCreateService.getAfterBegin();
        this.afterBeginMethod = ejbComponentCreateService.getAfterBeginMethod();
        this.afterCompletion = ejbComponentCreateService.getAfterCompletion();
        this.afterCompletionMethod = ejbComponentCreateService.getAfterCompletionMethod();
        this.beforeCompletion = ejbComponentCreateService.getBeforeCompletion();
        this.beforeCompletionMethod = ejbComponentCreateService.getBeforeCompletionMethod();
        this.methodAccessTimeouts = ejbComponentCreateService.getMethodApplicableAccessTimeouts();
        this.defaultAccessTimeoutProvider = ejbComponentCreateService.getDefaultAccessTimeoutService();
        StatefulTimeoutInfo statefulTimeout = ejbComponentCreateService.getStatefulTimeout();
        this.cache = statefulTimeout != null ? new ExpiringCache<StatefulSessionComponentInstance>(statefulTimeout.getValue(), statefulTimeout.getTimeUnit(), ejbComponentCreateService.getComponentClass().getName()) : new ExpiringCache<StatefulSessionComponentInstance>(-1L, TimeUnit.MILLISECONDS, ejbComponentCreateService.getComponentClass().getName());
        this.cache.setStatefulObjectFactory(new StatefulObjectFactory<StatefulSessionComponentInstance>(){

            @Override
            public StatefulSessionComponentInstance createInstance() {
                return (StatefulSessionComponentInstance)StatefulSessionComponent.this.createInstance();
            }

            @Override
            public void destroyInstance(StatefulSessionComponentInstance instance) {
                instance.destroy();
            }
        });
    }

    protected SessionID getSessionIdOf(InterceptorContext ctx) {
        StatefulSessionComponentInstance instance = (StatefulSessionComponentInstance)ctx.getPrivateData(ComponentInstance.class);
        return instance.getId();
    }

    @Override
    public <T> T getBusinessObject(Class<T> businessInterface, InterceptorContext context) throws IllegalStateException {
        if (businessInterface == null) {
            throw EjbMessages.MESSAGES.businessInterfaceIsNull();
        }
        return this.createViewInstanceProxy(businessInterface, Collections.singletonMap(SessionID.SESSION_ID_KEY, this.getSessionIdOf(context)));
    }

    @Override
    public EJBLocalObject getEJBLocalObject(InterceptorContext ctx) throws IllegalStateException {
        if (this.getEjbLocalObjectView() == null) {
            throw new IllegalStateException("Bean " + this.getComponentName() + " does not have an EJBLocalObject");
        }
        return this.createViewInstanceProxy(EJBLocalObject.class, Collections.singletonMap(SessionID.SESSION_ID_KEY, this.getSessionIdOf(ctx)), this.getEjbLocalObjectView());
    }

    @Override
    public EJBObject getEJBObject(InterceptorContext ctx) throws IllegalStateException {
        if (this.getEjbObjectView() == null) {
            throw EjbMessages.MESSAGES.beanComponentMissingEjbObject(this.getComponentName(), "EJBObject");
        }
        ServiceController serviceController = CurrentServiceContainer.getServiceContainer().getRequiredService(this.getEjbObjectView());
        ComponentView view = (ComponentView)serviceController.getValue();
        String locatorAppName = this.getEarApplicationName() == null ? "" : this.getEarApplicationName();
        return (EJBObject)EJBClient.createProxy((EJBLocator)new StatefulEJBLocator(view.getViewClass(), locatorAppName, this.getModuleName(), this.getComponentName(), this.getDistinctName(), this.getSessionIdOf(ctx)));
    }

    @Override
    public TimerService getTimerService() throws IllegalStateException {
        throw EjbMessages.MESSAGES.timerServiceNotSupportedForSFSB(this.getComponentName());
    }

    public AccessTimeoutDetails getAccessTimeout(Method method) {
        EJBBusinessMethod ejbMethod = new EJBBusinessMethod(method);
        AccessTimeoutDetails accessTimeout = this.methodAccessTimeouts.get(ejbMethod);
        if (accessTimeout != null) {
            return accessTimeout;
        }
        AccessTimeoutDetails timeout = (AccessTimeoutDetails)this.beanLevelAccessTimeout.get(method.getDeclaringClass().getName());
        if (timeout != null) {
            return timeout;
        }
        return this.defaultAccessTimeoutProvider.getDefaultAccessTimeout();
    }

    protected Interceptor createInterceptor(InterceptorFactory factory) {
        if (factory == null) {
            return null;
        }
        SimpleInterceptorFactoryContext context = new SimpleInterceptorFactoryContext();
        context.getContextData().put(Component.class, this);
        return factory.create((InterceptorFactoryContext)context);
    }

    public SessionID createSession() {
        return this.getCache().create().getId();
    }

    public Cache<StatefulSessionComponentInstance> getCache() {
        return this.cache;
    }

    protected BasicComponentInstance instantiateComponentInstance(AtomicReference<ManagedReference> instanceReference, Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors, InterceptorFactoryContext interceptorContext) {
        return new StatefulSessionComponentInstance(this, instanceReference, preDestroyInterceptor, methodInterceptors);
    }

    public void removeSession(SessionID sessionId) {
        this.getCache().remove(this.getTransactionManager(), sessionId);
    }

    public InterceptorFactory getAfterBegin() {
        return this.afterBegin;
    }

    public InterceptorFactory getAfterCompletion() {
        return this.afterCompletion;
    }

    public InterceptorFactory getBeforeCompletion() {
        return this.beforeCompletion;
    }

    public Method getAfterBeginMethod() {
        return this.afterBeginMethod;
    }

    public Method getAfterCompletionMethod() {
        return this.afterCompletionMethod;
    }

    public Method getBeforeCompletionMethod() {
        return this.beforeCompletionMethod;
    }

    public void start() {
        super.start();
        this.cache.start();
    }

    public void stop(StopContext stopContext) {
        super.stop(stopContext);
        this.cache.stop();
    }
}

