/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateless;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.component.pool.PoolConfig;
import org.jboss.as.ejb3.component.pool.PooledComponent;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.stateless.StatelessSessionComponentCreateService;
import org.jboss.as.ejb3.component.stateless.StatelessSessionComponentInstance;
import org.jboss.as.ejb3.pool.Pool;
import org.jboss.as.ejb3.pool.StatelessObjectFactory;
import org.jboss.as.ejb3.timerservice.PooledTimedObjectInvokerImpl;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.naming.ManagedReference;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public class StatelessSessionComponent
extends SessionBeanComponent
implements PooledComponent<StatelessSessionComponentInstance> {
    private final Pool<StatelessSessionComponentInstance> pool;
    private final Method timeoutMethod;
    private final TimedObjectInvoker timedObjectInvoker;

    public StatelessSessionComponent(StatelessSessionComponentCreateService slsbComponentCreateService) {
        super(slsbComponentCreateService);
        StatelessObjectFactory<StatelessSessionComponentInstance> factory = new StatelessObjectFactory<StatelessSessionComponentInstance>(){

            @Override
            public StatelessSessionComponentInstance create() {
                return (StatelessSessionComponentInstance)StatelessSessionComponent.this.createInstance();
            }

            @Override
            public void destroy(StatelessSessionComponentInstance obj) {
                obj.destroy();
            }
        };
        PoolConfig poolConfig = slsbComponentCreateService.getPoolConfig();
        if (poolConfig == null) {
            EjbLogger.ROOT_LOGGER.debug("Pooling is disabled for Stateless EJB " + slsbComponentCreateService.getComponentName());
            this.pool = null;
        } else {
            EjbLogger.ROOT_LOGGER.debug("Using pool config " + poolConfig + " to create pool for Stateless EJB " + slsbComponentCreateService.getComponentName());
            this.pool = poolConfig.createPool(factory);
        }
        this.timeoutMethod = slsbComponentCreateService.getTimeoutMethod();
        String deploymentName = slsbComponentCreateService.getDistinctName() == null || slsbComponentCreateService.getDistinctName().length() == 0 ? slsbComponentCreateService.getApplicationName() + "." + slsbComponentCreateService.getModuleName() : slsbComponentCreateService.getApplicationName() + "." + slsbComponentCreateService.getModuleName() + "." + slsbComponentCreateService.getDistinctName();
        this.timedObjectInvoker = new PooledTimedObjectInvokerImpl(this, deploymentName);
    }

    protected BasicComponentInstance instantiateComponentInstance(AtomicReference<ManagedReference> instanceReference, Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors, InterceptorFactoryContext interceptorContext) {
        Map<Method, Interceptor> timeouts;
        if (this.timeoutInterceptors != null) {
            timeouts = new HashMap();
            for (Map.Entry entry : this.timeoutInterceptors.entrySet()) {
                timeouts.put((Method)entry.getKey(), ((InterceptorFactory)entry.getValue()).create(interceptorContext));
            }
        } else {
            timeouts = Collections.emptyMap();
        }
        return new StatelessSessionComponentInstance(this, instanceReference, preDestroyInterceptor, methodInterceptors, timeouts);
    }

    @Override
    public Pool<StatelessSessionComponentInstance> getPool() {
        return this.pool;
    }

    @Override
    public TimedObjectInvoker getTimedObjectInvoker() {
        return this.timedObjectInvoker;
    }

    @Override
    public Method getTimeoutMethod() {
        return this.timeoutMethod;
    }
}

