/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;

public class EjbClientContextParsingProcessor
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(EjbClientContextParsingProcessor.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit parentDeploymentUnit = deploymentUnit.getParent();
        ServiceName ejbClientContextServiceName = parentDeploymentUnit != null ? (ServiceName)parentDeploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_CLIENT_CONTEXT_SERVICE_NAME) : (ServiceName)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_CLIENT_CONTEXT_SERVICE_NAME);
        if (ejbClientContextServiceName == null) {
            throw new IllegalStateException("Deployment unit " + deploymentUnit + " doesn't contain the service name for EJB client context");
        }
        logger.debug((Object)("Using " + ejbClientContextServiceName + " as the EJB client context service for deployment unit " + deploymentUnit));
        phaseContext.addDeploymentDependency(ejbClientContextServiceName, EjbDeploymentAttachmentKeys.EJB_CLIENT_CONTEXT);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

