/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.repository.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jboss.as.server.deployment.repository.api.ContentRepository;
import org.jboss.as.server.deployment.repository.impl.DeploymentRepositoryLogger;
import org.jboss.as.server.deployment.repository.impl.DeploymentRepositoryMessages;
import org.jboss.as.server.deployment.repository.impl.HashUtil;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class ContentRepositoryImpl
implements ContentRepository,
Service<ContentRepository> {
    protected static final String CONTENT = "content";
    private final File repoRoot;
    protected final MessageDigest messageDigest;

    public static ContentRepositoryImpl addService(ServiceTarget serviceTarget, File repoRoot) {
        ContentRepositoryImpl contentRepository = new ContentRepositoryImpl(repoRoot);
        serviceTarget.addService(ContentRepository.SERVICE_NAME, (Service)contentRepository).install();
        return contentRepository;
    }

    protected ContentRepositoryImpl(File repoRoot) {
        if (repoRoot == null) {
            throw DeploymentRepositoryMessages.MESSAGES.nullVar("repoRoot");
        }
        if (repoRoot.exists()) {
            if (!repoRoot.isDirectory()) {
                throw DeploymentRepositoryMessages.MESSAGES.notADirectory(repoRoot.getAbsolutePath());
            }
            if (!repoRoot.canWrite()) {
                throw DeploymentRepositoryMessages.MESSAGES.directoryNotWritable(repoRoot.getAbsolutePath());
            }
        } else if (!repoRoot.mkdirs()) {
            throw DeploymentRepositoryMessages.MESSAGES.cannotCreateDirectory(repoRoot.getAbsolutePath());
        }
        this.repoRoot = repoRoot;
        try {
            this.messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw DeploymentRepositoryMessages.MESSAGES.cannotObtainSha1(e, MessageDigest.class.getSimpleName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] addContent(InputStream stream) throws IOException {
        byte[] sha1Bytes = null;
        File tmp = File.createTempFile(CONTENT, "tmp", this.repoRoot);
        FileOutputStream fos = new FileOutputStream(tmp);
        MessageDigest messageDigest = this.messageDigest;
        synchronized (messageDigest) {
            this.messageDigest.reset();
            try {
                int read;
                DigestOutputStream dos = new DigestOutputStream(fos, this.messageDigest);
                BufferedInputStream bis = new BufferedInputStream(stream);
                byte[] bytes = new byte[8192];
                while ((read = bis.read(bytes)) > -1) {
                    dos.write(bytes, 0, read);
                }
            }
            finally {
                ContentRepositoryImpl.safeClose(fos);
            }
            sha1Bytes = this.messageDigest.digest();
        }
        File realFile = this.getDeploymentContentFile(sha1Bytes, true);
        if (this.hasContent(sha1Bytes)) {
            if (!tmp.delete()) {
                tmp.deleteOnExit();
            }
            DeploymentRepositoryLogger.ROOT_LOGGER.debugf("Content was already present in repository at location %s", realFile.getAbsolutePath());
        } else {
            this.moveTempToPermanent(tmp, realFile);
            DeploymentRepositoryLogger.ROOT_LOGGER.contentAdded(realFile.getAbsolutePath());
        }
        return sha1Bytes;
    }

    @Override
    public VirtualFile getContent(byte[] hash) {
        if (hash == null) {
            throw DeploymentRepositoryMessages.MESSAGES.nullVar("hash");
        }
        return VFS.getChild((URI)this.getDeploymentContentFile(hash, true).toURI());
    }

    @Override
    public boolean hasContent(byte[] hash) {
        return this.getDeploymentContentFile(hash).exists();
    }

    protected File getRepoRoot() {
        return this.repoRoot;
    }

    protected File getDeploymentContentFile(byte[] deploymentHash) {
        return this.getDeploymentContentFile(deploymentHash, false);
    }

    private File getDeploymentContentFile(byte[] deploymentHash, boolean validate) {
        File hashDir = this.getDeploymentHashDir(deploymentHash, validate);
        return new File(hashDir, CONTENT);
    }

    protected File getDeploymentHashDir(byte[] deploymentHash, boolean validate) {
        String sha1 = HashUtil.bytesToHexString(deploymentHash);
        String partA = sha1.substring(0, 2);
        String partB = sha1.substring(2);
        File base = new File(this.getRepoRoot(), partA);
        if (validate) {
            this.validateDir(base);
        }
        File hashDir = new File(base, partB);
        if (validate && !hashDir.exists() && !hashDir.mkdirs()) {
            throw DeploymentRepositoryMessages.MESSAGES.cannotCreateDirectory(hashDir.getAbsolutePath());
        }
        return hashDir;
    }

    protected void validateDir(File dir) {
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw DeploymentRepositoryMessages.MESSAGES.cannotCreateDirectory(dir.getAbsolutePath());
            }
        } else {
            if (!dir.isDirectory()) {
                throw DeploymentRepositoryMessages.MESSAGES.notADirectory(dir.getAbsolutePath());
            }
            if (!dir.canWrite()) {
                throw DeploymentRepositoryMessages.MESSAGES.directoryNotWritable(dir.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTempToPermanent(File tmpFile, File permanentFile) throws IOException {
        if (!tmpFile.renameTo(permanentFile)) {
            FileOutputStream fos = null;
            BufferedOutputStream bos = null;
            FileInputStream fis = null;
            try {
                int read;
                fos = new FileOutputStream(permanentFile);
                bos = new BufferedOutputStream(fos);
                fis = new FileInputStream(tmpFile);
                BufferedInputStream bis = new BufferedInputStream(fis);
                byte[] bytes = new byte[8192];
                while ((read = bis.read(bytes)) > -1) {
                    bos.write(bytes, 0, read);
                }
            }
            catch (Throwable throwable) {
                ContentRepositoryImpl.safeClose(bos);
                ContentRepositoryImpl.safeClose(fos);
                ContentRepositoryImpl.safeClose(fis);
                if (!tmpFile.delete()) {
                    tmpFile.deleteOnExit();
                }
                throw throwable;
            }
            ContentRepositoryImpl.safeClose(bos);
            ContentRepositoryImpl.safeClose(fos);
            ContentRepositoryImpl.safeClose(fis);
            if (!tmpFile.delete()) {
                tmpFile.deleteOnExit();
            }
        }
    }

    @Override
    public void removeContent(byte[] hash) {
        File file = this.getDeploymentContentFile(hash, true);
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    protected static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void start(StartContext context) throws StartException {
        DeploymentRepositoryLogger.ROOT_LOGGER.debugf("%s started", ContentRepository.class.getSimpleName());
    }

    public void stop(StopContext context) {
        DeploymentRepositoryLogger.ROOT_LOGGER.debugf("%s stopped", ContentRepository.class.getSimpleName());
    }

    public ContentRepository getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

