/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.deployers.EEResourceReferenceProcessor;

public class EEResourceReferenceProcessorRegistry {
    private static final Map<String, EEResourceReferenceProcessor> resourceReferenceProcessors = new ConcurrentHashMap<String, EEResourceReferenceProcessor>();

    public static void registerResourceReferenceProcessor(EEResourceReferenceProcessor resourceReferenceProcessor) {
        if (resourceReferenceProcessor == null) {
            throw EeMessages.MESSAGES.nullResourceReference();
        }
        String resourceReferenceType = resourceReferenceProcessor.getResourceReferenceType();
        if (resourceReferenceType == null || resourceReferenceType.trim().isEmpty()) {
            throw EeMessages.MESSAGES.nullOrEmptyResourceReferenceType();
        }
        resourceReferenceProcessors.put(resourceReferenceType, resourceReferenceProcessor);
    }

    public static void unregisterResourceReferenceProcessor(String resourceReferenceType) {
        if (resourceReferenceType == null || resourceReferenceType.trim().isEmpty()) {
            throw EeMessages.MESSAGES.nullOrEmptyResourceReferenceType();
        }
        if (!resourceReferenceProcessors.containsKey(resourceReferenceType)) {
            throw EeMessages.MESSAGES.resourceReferenceNotRegistered(resourceReferenceType);
        }
        resourceReferenceProcessors.remove(resourceReferenceType);
    }

    public static EEResourceReferenceProcessor getResourceReferenceProcessor(String resourceReferenceType) {
        return resourceReferenceProcessors.get(resourceReferenceType);
    }
}

