/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.logging.Handler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.FileHandlerService;
import org.jboss.as.logging.FlushingHandlerAddProperties;
import org.jboss.as.logging.HandlerFileService;
import org.jboss.as.logging.LogServices;
import org.jboss.as.server.services.path.AbstractPathService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

class FileHandlerAdd
extends FlushingHandlerAddProperties<FileHandlerService> {
    static final FileHandlerAdd INSTANCE = new FileHandlerAdd();

    private FileHandlerAdd() {
        super(new AttributeDefinition[]{CommonAttributes.APPEND, CommonAttributes.FILE});
    }

    @Override
    protected FileHandlerService createHandlerService(OperationContext context, ModelNode model) throws OperationFailedException {
        return new FileHandlerService();
    }

    @Override
    protected void updateRuntime(OperationContext context, ServiceBuilder<Handler> serviceBuilder, String name, FileHandlerService service, ModelNode model) throws OperationFailedException {
        super.updateRuntime(context, serviceBuilder, name, service, model);
        ModelNode append = CommonAttributes.APPEND.resolveModelAttribute(context, model);
        if (append.isDefined()) {
            service.setAppend(append.asBoolean());
        }
        ServiceTarget serviceTarget = context.getServiceTarget();
        ModelNode file = CommonAttributes.FILE.resolveModelAttribute(context, model);
        if (file.isDefined()) {
            HandlerFileService fileService = new HandlerFileService(CommonAttributes.PATH.validateOperation(file).asString());
            ServiceBuilder fileBuilder = serviceTarget.addService(LogServices.handlerFileName(name), (Service)fileService);
            ModelNode relativeTo = CommonAttributes.RELATIVE_TO.resolveModelAttribute(context, file);
            if (relativeTo.isDefined()) {
                fileBuilder.addDependency(AbstractPathService.pathNameOf((String)relativeTo.asString()), String.class, fileService.getRelativeToInjector());
            }
            fileBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
            serviceBuilder.addDependency(LogServices.handlerFileName(name), String.class, service.getFileNameInjector());
        }
    }
}

