/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.jacorb.JacORBSubsystemDefinitions;
import org.jboss.as.jacorb.JacORBSubsystemParser;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class JacORBSubsystemProviders {
    static final String RESOURCE_NAME = JacORBSubsystemProviders.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystem(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystemAdd(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_REMOVE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystemRemove(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_DESCRIBE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    };

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    private static class Descriptions {
        private Descriptions() {
        }

        static ModelNode getSubsystem(Locale locale) {
            ResourceBundle bundle2 = JacORBSubsystemProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle2.getString("jacorb"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(JacORBSubsystemParser.Namespace.CURRENT.getUriString());
            for (SimpleAttributeDefinition attrDefinition : JacORBSubsystemDefinitions.ORB_ATTRIBUTES) {
                attrDefinition.addResourceAttributeDescription(bundle2, "orb", subsystem);
            }
            for (SimpleAttributeDefinition attrDefinition : JacORBSubsystemDefinitions.ORB_CONN_ATTRIBUTES) {
                attrDefinition.addResourceAttributeDescription(bundle2, "orb.conn", subsystem);
            }
            for (SimpleAttributeDefinition attrDefinition : JacORBSubsystemDefinitions.ORB_INIT_ATTRIBUTES) {
                attrDefinition.addResourceAttributeDescription(bundle2, "orb.init", subsystem);
            }
            for (SimpleAttributeDefinition attrDefinition : JacORBSubsystemDefinitions.POA_ATTRIBUTES) {
                attrDefinition.addResourceAttributeDescription(bundle2, "poa", subsystem);
            }
            for (SimpleAttributeDefinition attrDefinition : JacORBSubsystemDefinitions.POA_RP_ATTRIBUTES) {
                attrDefinition.addResourceAttributeDescription(bundle2, "poa.request-processors", subsystem);
            }
            for (SimpleAttributeDefinition attrDefinition : JacORBSubsystemDefinitions.NAMING_ATTRIBUTES) {
                attrDefinition.addResourceAttributeDescription(bundle2, "naming", subsystem);
            }
            for (SimpleAttributeDefinition attrDefinition : JacORBSubsystemDefinitions.INTEROP_ATTRIBUTES) {
                attrDefinition.addResourceAttributeDescription(bundle2, "interop", subsystem);
            }
            for (SimpleAttributeDefinition attrDefinition : JacORBSubsystemDefinitions.SECURITY_ATTRIBUTES) {
                attrDefinition.addResourceAttributeDescription(bundle2, "security", subsystem);
            }
            Descriptions.addPropertiesDescriptions(subsystem.get(new String[]{"attributes", "properties"}), locale);
            return subsystem;
        }

        static ModelNode getSubsystemAdd(Locale locale) {
            ResourceBundle bundle2 = JacORBSubsystemProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("add");
            op.get("description").set(bundle2.getString("jacorb.add"));
            for (SimpleAttributeDefinition attrDefinition : JacORBSubsystemDefinitions.ORB_ATTRIBUTES) {
                attrDefinition.addOperationParameterDescription(bundle2, "orb", op);
            }
            for (SimpleAttributeDefinition attrDefinition : JacORBSubsystemDefinitions.ORB_CONN_ATTRIBUTES) {
                attrDefinition.addOperationParameterDescription(bundle2, "orb.conn", op);
            }
            for (SimpleAttributeDefinition attrDefinition : JacORBSubsystemDefinitions.ORB_INIT_ATTRIBUTES) {
                attrDefinition.addOperationParameterDescription(bundle2, "orb.init", op);
            }
            for (SimpleAttributeDefinition attrDefinition : JacORBSubsystemDefinitions.POA_ATTRIBUTES) {
                attrDefinition.addOperationParameterDescription(bundle2, "poa", op);
            }
            for (SimpleAttributeDefinition attrDefinition : JacORBSubsystemDefinitions.POA_RP_ATTRIBUTES) {
                attrDefinition.addOperationParameterDescription(bundle2, "poa.request-processors", op);
            }
            for (SimpleAttributeDefinition attrDefinition : JacORBSubsystemDefinitions.NAMING_ATTRIBUTES) {
                attrDefinition.addOperationParameterDescription(bundle2, "naming", op);
            }
            for (SimpleAttributeDefinition attrDefinition : JacORBSubsystemDefinitions.INTEROP_ATTRIBUTES) {
                attrDefinition.addOperationParameterDescription(bundle2, "interop", op);
            }
            for (SimpleAttributeDefinition attrDefinition : JacORBSubsystemDefinitions.SECURITY_ATTRIBUTES) {
                attrDefinition.addOperationParameterDescription(bundle2, "security", op);
            }
            Descriptions.addPropertiesDescriptions(op.get(new String[]{"request-properties", "properties"}), locale);
            op.get("reply-properties").setEmptyObject();
            return op;
        }

        static ModelNode getSubsystemRemove(Locale locale) {
            ResourceBundle bundle2 = JacORBSubsystemProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("remove");
            op.get("description").set(bundle2.getString("jacorb.remove"));
            op.get("request-properties").setEmptyObject();
            op.get("reply-properties").setEmptyObject();
            return op;
        }

        static void addPropertiesDescriptions(ModelNode node, Locale locale) {
            ResourceBundle bundle2 = JacORBSubsystemProviders.getResourceBundle(locale);
            node.get("description").set(bundle2.getString("properties"));
            node.get("type").set(ModelType.LIST);
            node.get("required").set(false);
            node.get(new String[]{"value-type", "name", "description"}).set(bundle2.getString("properties.name"));
            node.get(new String[]{"value-type", "name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"value-type", "value", "description"}).set(bundle2.getString("properties.value"));
            node.get(new String[]{"value-type", "value", "type"}).set(ModelType.STRING);
        }
    }
}

