/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.vault;

import java.io.Console;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.jboss.as.security.vault.VaultInteraction;
import org.jboss.security.plugins.PBEUtils;
import org.jboss.security.vault.SecurityVault;
import org.jboss.security.vault.SecurityVaultException;
import org.jboss.security.vault.SecurityVaultFactory;

public class VaultInteractiveSession {
    private String maskedPassword;
    private String salt;
    private String keystoreURL;
    private String encDir;
    private String keystoreAlias;
    private int iterationCount = 0;
    private byte[] handshakeKey;
    private SecurityVault vault = null;

    public void start() {
        Console console = System.console();
        if (console == null) {
            System.err.println("No console.");
            System.exit(1);
        }
        while (this.encDir == null || this.encDir.length() == 0 || !this.encDir.endsWith("/") && !this.encDir.endsWith("\\")) {
            this.encDir = console.readLine("Enter directory to store encrypted files (end with either / or \\ based on Unix or Windows:", new Object[0]);
        }
        while (this.keystoreURL == null || this.keystoreURL.length() == 0) {
            this.keystoreURL = console.readLine("Enter Keystore URL:", new Object[0]);
        }
        char[] keystorePasswd = VaultInteractiveSession.getSensitiveValue("Enter Keystore password");
        try {
            this.maskedPassword = this.getMaskedPassword(console, new String(keystorePasswd));
            System.out.println("                ");
            System.out.println("Please make note of the following:");
            System.out.println("********************************************");
            System.out.println("Masked Password:" + this.maskedPassword);
            System.out.println("salt:" + this.salt);
            System.out.println("Iteration Count:" + this.iterationCount);
            System.out.println("********************************************");
            System.out.println("                ");
        }
        catch (Exception e) {
            System.out.println("Exception encountered:" + e.getLocalizedMessage());
        }
        while (this.keystoreAlias == null || this.keystoreAlias.length() == 0) {
            this.keystoreAlias = console.readLine("Enter Keystore Alias:", new Object[0]);
        }
        try {
            this.vault = SecurityVaultFactory.get();
            System.out.println("Obtained Vault");
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.putAll(this.getMap());
            System.out.println("Intializing Vault");
            this.vault.init(options);
            System.out.println("Vault is initialized and ready for use");
            this.handshake();
            System.out.println("Handshake with Vault complete");
            VaultInteraction vaultInteraction = new VaultInteraction(this.vault, this.handshakeKey);
            vaultInteraction.start();
        }
        catch (SecurityVaultException e) {
            System.out.println("Exception encountered:" + e.getLocalizedMessage());
        }
    }

    public static char[] getSensitiveValue(String passwordPrompt) {
        char[] passwd;
        while (true) {
            char[] passwd1;
            Console console;
            boolean noMatch;
            if (passwordPrompt == null) {
                passwordPrompt = "Enter your password";
            }
            boolean bl = noMatch = !Arrays.equals(passwd = (console = System.console()).readPassword(passwordPrompt + ": ", new Object[0]), passwd1 = console.readPassword(passwordPrompt + " again: ", new Object[0]));
            if (!noMatch) break;
            System.out.println("Values entered don't match");
        }
        System.out.println("Values match");
        return passwd;
    }

    private String getMaskedPassword(Console console, String passwd) throws Exception {
        while (this.salt == null || this.salt.length() != 8) {
            this.salt = console.readLine("Enter 8 character salt:", new Object[0]);
        }
        String ic = console.readLine("Enter iteration count as a number (Eg: 44):", new Object[0]);
        this.iterationCount = Integer.parseInt(ic);
        String algo = "PBEwithMD5andDES";
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBEwithMD5andDES");
        char[] password = "somearbitrarycrazystringthatdoesnotmatter".toCharArray();
        PBEParameterSpec cipherSpec = new PBEParameterSpec(this.salt.getBytes(), this.iterationCount);
        PBEKeySpec keySpec = new PBEKeySpec(password);
        SecretKey cipherKey = factory.generateSecret(keySpec);
        String maskedPass = PBEUtils.encode64((byte[])passwd.getBytes(), (String)algo, (SecretKey)cipherKey, (PBEParameterSpec)cipherSpec);
        return new String("MASK-") + maskedPass;
    }

    private Map<String, Object> getMap() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("KEYSTORE_URL", this.keystoreURL);
        options.put("KEYSTORE_PASSWORD", this.maskedPassword);
        options.put("KEYSTORE_ALIAS", this.keystoreAlias);
        options.put("SALT", this.salt);
        options.put("ITERATION_COUNT", "" + this.iterationCount);
        options.put("ENC_FILE_DIR", this.encDir);
        return options;
    }

    private void handshake() throws SecurityVaultException {
        HashMap<String, String> handshakeOptions = new HashMap<String, String>();
        handshakeOptions.put("PUBLIC_CERT", this.keystoreAlias);
        this.handshakeKey = this.vault.handshake(handshakeOptions);
    }
}

