/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.platform.mbean.AbstractPlatformMBeanAttributeHandler;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.dmr.ModelNode;

public class RuntimeMXBeanAttributeHandler
extends AbstractPlatformMBeanAttributeHandler {
    public static RuntimeMXBeanAttributeHandler INSTANCE = new RuntimeMXBeanAttributeHandler();

    private RuntimeMXBeanAttributeHandler() {
    }

    @Override
    protected void executeReadAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = operation.require("name").asString();
        try {
            if (!(PlatformMBeanUtil.JVM_MAJOR_VERSION > 6 && "object-name".equals(name) || PlatformMBeanConstants.RUNTIME_READ_ATTRIBUTES.contains(name) || PlatformMBeanConstants.RUNTIME_METRICS.contains(name))) {
                throw RuntimeMXBeanAttributeHandler.unknownAttribute(operation);
            }
            RuntimeMXBeanAttributeHandler.storeResult(name, context.getResult());
        }
        catch (SecurityException e) {
            throw new OperationFailedException(new ModelNode().set(e.toString()));
        }
        catch (UnsupportedOperationException e) {
            throw new OperationFailedException(new ModelNode().set(e.toString()));
        }
    }

    @Override
    protected void executeWriteAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        throw RuntimeMXBeanAttributeHandler.unknownAttribute(operation);
    }

    @Override
    protected void register(ManagementResourceRegistration registration) {
        if (PlatformMBeanUtil.JVM_MAJOR_VERSION > 6) {
            registration.registerReadOnlyAttribute("object-name", (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
        for (String attribute : PlatformMBeanConstants.RUNTIME_READ_ATTRIBUTES) {
            registration.registerReadOnlyAttribute(attribute, (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
        for (String attribute : PlatformMBeanConstants.RUNTIME_METRICS) {
            registration.registerMetric(attribute, (OperationStepHandler)this);
        }
    }

    static void storeResult(String name, ModelNode store) {
        if (PlatformMBeanUtil.JVM_MAJOR_VERSION > 6 && "object-name".equals(name)) {
            store.set("java.lang:type=Runtime");
        } else if ("name".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getName());
        } else if ("vm-name".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getVmName());
        } else if ("vm-vendor".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getVmVendor());
        } else if ("vm-version".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getVmVersion());
        } else if ("spec-name".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getSpecName());
        } else if ("spec-vendor".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getSpecVendor());
        } else if ("spec-version".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getSpecVersion());
        } else if ("management-spec-version".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getManagementSpecVersion());
        } else if ("class-path".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getClassPath());
        } else if ("library-path".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getLibraryPath());
        } else if ("boot-class-path-supported".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().isBootClassPathSupported());
        } else if ("boot-class-path".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getBootClassPath());
        } else if ("input-arguments".equals(name)) {
            store.setEmptyList();
            for (String arg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
                store.add(arg);
            }
        } else if ("uptime".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getUptime());
        } else if ("start-time".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getStartTime());
        } else if ("system-properties".equals(name)) {
            store.setEmptyObject();
            TreeMap<String, String> sorted = new TreeMap<String, String>(ManagementFactory.getRuntimeMXBean().getSystemProperties());
            for (Map.Entry<String, String> prop : sorted.entrySet()) {
                ModelNode propNode = store.get(prop.getKey());
                if (prop.getValue() == null) continue;
                propNode.set(prop.getValue());
            }
        } else if (PlatformMBeanConstants.RUNTIME_READ_ATTRIBUTES.contains(name) || PlatformMBeanConstants.RUNTIME_METRICS.contains(name)) {
            throw new IllegalStateException(String.format("Read support for attribute %s was not properly implemented", name));
        }
    }
}

