/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.arquillian;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;
import org.jboss.weld.Container;
import org.jboss.weld.context.bound.BoundConversationContext;
import org.jboss.weld.context.bound.BoundLiteral;
import org.jboss.weld.context.bound.BoundRequest;
import org.jboss.weld.context.bound.BoundRequestContext;
import org.jboss.weld.context.bound.BoundSessionContext;
import org.jboss.weld.context.bound.MutableBoundRequest;

public class WeldContextSetup
implements SetupAction {
    private static final String STANDARD_BEAN_MANAGER_JNDI_NAME = "java:comp/BeanManager";
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.arquillian");
    private final ThreadLocal<Map<String, Object>> sessionContexts = new ContextMapThreadLocal();
    private final ThreadLocal<Map<String, Object>> requestContexts = new ContextMapThreadLocal();
    private final ThreadLocal<BoundRequest> boundRequests = new ThreadLocal();

    public void setup(Map<String, Object> properties) {
        try {
            BeanManager manager = (BeanManager)new InitialContext().lookup(STANDARD_BEAN_MANAGER_JNDI_NAME);
            if (manager != null && Container.available()) {
                Bean sessionContextBean = manager.resolve(manager.getBeans(BoundSessionContext.class, new Annotation[]{BoundLiteral.INSTANCE}));
                CreationalContext ctx = manager.createCreationalContext((Contextual)sessionContextBean);
                BoundSessionContext sessionContext = (BoundSessionContext)manager.getReference(sessionContextBean, BoundSessionContext.class, ctx);
                sessionContext.associate(this.sessionContexts.get());
                sessionContext.activate();
                Bean requestContextBean = manager.resolve(manager.getBeans(BoundRequestContext.class, new Annotation[]{BoundLiteral.INSTANCE}));
                ctx = manager.createCreationalContext((Contextual)requestContextBean);
                BoundRequestContext requestContext = (BoundRequestContext)manager.getReference(requestContextBean, BoundRequestContext.class, ctx);
                requestContext.associate(this.requestContexts.get());
                requestContext.activate();
                Bean conversationContextBean = manager.resolve(manager.getBeans(BoundConversationContext.class, new Annotation[]{BoundLiteral.INSTANCE}));
                ctx = manager.createCreationalContext((Contextual)conversationContextBean);
                BoundConversationContext conversationContext = (BoundConversationContext)manager.getReference(conversationContextBean, BoundConversationContext.class, ctx);
                MutableBoundRequest request = new MutableBoundRequest(this.requestContexts.get(), this.sessionContexts.get());
                this.boundRequests.set((BoundRequest)request);
                conversationContext.associate((Object)request);
                conversationContext.activate();
            }
        }
        catch (NamingException e) {
            log.error((Object)"Failed to setup Weld contexts", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void teardown(Map<String, Object> properties) {
        try {
            BeanManager manager = (BeanManager)new InitialContext().lookup(STANDARD_BEAN_MANAGER_JNDI_NAME);
            if (manager != null && Container.available()) {
                Bean sessionContextBean = manager.resolve(manager.getBeans(BoundSessionContext.class, new Annotation[]{BoundLiteral.INSTANCE}));
                CreationalContext ctx = manager.createCreationalContext((Contextual)sessionContextBean);
                BoundSessionContext sessionContext = (BoundSessionContext)manager.getReference(sessionContextBean, BoundSessionContext.class, ctx);
                sessionContext.deactivate();
                sessionContext.dissociate(this.sessionContexts.get());
                Bean requestContextBean = manager.resolve(manager.getBeans(BoundRequestContext.class, new Annotation[]{BoundLiteral.INSTANCE}));
                ctx = manager.createCreationalContext((Contextual)requestContextBean);
                BoundRequestContext requestContext = (BoundRequestContext)manager.getReference(requestContextBean, BoundRequestContext.class, ctx);
                requestContext.deactivate();
                requestContext.dissociate(this.requestContexts.get());
                Bean conversationContextBean = manager.resolve(manager.getBeans(BoundConversationContext.class, new Annotation[]{BoundLiteral.INSTANCE}));
                ctx = manager.createCreationalContext((Contextual)conversationContextBean);
                BoundConversationContext conversationContext = (BoundConversationContext)manager.getReference(conversationContextBean, BoundConversationContext.class, ctx);
                conversationContext.deactivate();
                conversationContext.dissociate((Object)this.boundRequests.get());
            }
        }
        catch (NamingException e) {
            log.error((Object)"Failed to tear down Weld contexts", (Throwable)e);
        }
        finally {
            this.sessionContexts.remove();
            this.requestContexts.remove();
            this.boundRequests.remove();
        }
    }

    public Set<ServiceName> dependencies() {
        return Collections.emptySet();
    }

    public int priority() {
        return 100;
    }

    private static class ContextMapThreadLocal
    extends ThreadLocal<Map<String, Object>> {
        private ContextMapThreadLocal() {
        }

        @Override
        protected Map<String, Object> initialValue() {
            return new ConcurrentHashMap<String, Object>();
        }
    }
}

