/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.envers.entities.EntityConfiguration;
import org.hibernate.envers.entities.RelationDescription;
import org.hibernate.envers.entities.RelationType;

public class EntitiesConfigurations {
    private Map<String, EntityConfiguration> entitiesConfigurations;
    private Map<String, EntityConfiguration> notAuditedEntitiesConfigurations;
    private Map<String, String> entityNamesForVersionsEntityNames = new HashMap<String, String>();

    public EntitiesConfigurations(Map<String, EntityConfiguration> entitiesConfigurations, Map<String, EntityConfiguration> notAuditedEntitiesConfigurations) {
        this.entitiesConfigurations = entitiesConfigurations;
        this.notAuditedEntitiesConfigurations = notAuditedEntitiesConfigurations;
        this.generateBidirectionRelationInfo();
        this.generateVersionsEntityToEntityNames();
    }

    private void generateVersionsEntityToEntityNames() {
        this.entityNamesForVersionsEntityNames = new HashMap<String, String>();
        for (String entityName : this.entitiesConfigurations.keySet()) {
            this.entityNamesForVersionsEntityNames.put(this.entitiesConfigurations.get(entityName).getVersionsEntityName(), entityName);
        }
    }

    private void generateBidirectionRelationInfo() {
        for (String entityName : this.entitiesConfigurations.keySet()) {
            EntityConfiguration entCfg = this.entitiesConfigurations.get(entityName);
            for (RelationDescription relDesc : entCfg.getRelationsIterator()) {
                EntityConfiguration entityConfiguration;
                if (relDesc.getRelationType() != RelationType.TO_ONE && relDesc.getRelationType() != RelationType.TO_MANY_MIDDLE || (entityConfiguration = this.entitiesConfigurations.get(relDesc.getToEntityName())) == null) continue;
                for (RelationDescription other : entityConfiguration.getRelationsIterator()) {
                    if (!relDesc.getFromPropertyName().equals(other.getMappedByPropertyName()) || !entityName.equals(other.getToEntityName())) continue;
                    relDesc.setBidirectional(true);
                    other.setBidirectional(true);
                }
            }
        }
    }

    public EntityConfiguration get(String entityName) {
        return this.entitiesConfigurations.get(entityName);
    }

    public EntityConfiguration getNotVersionEntityConfiguration(String entityName) {
        return this.notAuditedEntitiesConfigurations.get(entityName);
    }

    public String getEntityNameForVersionsEntityName(String versionsEntityName) {
        return this.entityNamesForVersionsEntityNames.get(versionsEntityName);
    }

    public boolean isVersioned(String entityName) {
        return this.get(entityName) != null;
    }

    public boolean hasAuditedEntities() {
        return this.entitiesConfigurations.size() != 0;
    }

    public RelationDescription getRelationDescription(String entityName, String propertyName) {
        EntityConfiguration entCfg = this.entitiesConfigurations.get(entityName);
        RelationDescription relDesc = entCfg.getRelationDescription(propertyName);
        if (relDesc != null) {
            return relDesc;
        }
        if (entCfg.getParentEntityName() != null) {
            return this.getRelationDescription(entCfg.getParentEntityName(), propertyName);
        }
        return null;
    }
}

