/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.resource.AbstractSocketBindingResourceDefinition;
import org.jboss.dmr.ModelNode;

public class SocketBindingAddHandler
extends AbstractAddStepHandler {
    public static final String OPERATION_NAME = "add";
    public static final SocketBindingAddHandler INSTANCE = new SocketBindingAddHandler();

    public static ModelNode getOperation(ModelNode address, ModelNode socketBinding) {
        ModelNode op = new ModelNode();
        op.get("operation").set(OPERATION_NAME);
        op.get("address").set(address);
        if (socketBinding.get("interface").isDefined()) {
            op.get("interface").set(socketBinding.get("interface"));
        }
        op.get("port").set(socketBinding.get("port"));
        if (socketBinding.get("fixed-port").isDefined()) {
            op.get("fixed-port").set(socketBinding.get("fixed-port"));
        }
        if (socketBinding.get("multicast-address").isDefined()) {
            op.get("multicast-address").set(socketBinding.get("multicast-address"));
        }
        if (socketBinding.get("multicast-port").isDefined()) {
            op.get("multicast-port").set(socketBinding.get("multicast-port"));
        }
        return op;
    }

    protected SocketBindingAddHandler() {
    }

    @Override
    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress(operation.get("address"));
        String name = address.getLastElement().getValue();
        model.get("name").set(name);
        AbstractSocketBindingResourceDefinition.INTERFACE.validateAndSet(operation, model);
        AbstractSocketBindingResourceDefinition.PORT.validateAndSet(operation, model);
        AbstractSocketBindingResourceDefinition.FIXED_PORT.validateAndSet(operation, model);
        AbstractSocketBindingResourceDefinition.MULTICAST_ADDRESS.validateAndSet(operation, model);
        AbstractSocketBindingResourceDefinition.MULTICAST_PORT.validateAndSet(operation, model);
    }
}

